/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.core.construction.SplittableParDo;
import org.apache.beam.runners.spark.SparkNativePipelineVisitor;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineResult;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.TestSparkPipelineOptions;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkContextFactory;
import org.apache.beam.runners.spark.translation.TransformTranslator;
import org.apache.beam.runners.spark.translation.streaming.StreamingTransformTranslator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsValidator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SparkRunnerDebugger
extends PipelineRunner<SparkPipelineResult> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkRunnerDebugger.class);
    private final @UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options;

    private SparkRunnerDebugger(@UnknownKeyFor @NonNull @Initialized SparkPipelineOptions options) {
        this.options = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized SparkRunnerDebugger fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        if (options instanceof TestSparkPipelineOptions) {
            TestSparkPipelineOptions testSparkPipelineOptions = (TestSparkPipelineOptions)PipelineOptionsValidator.validate(TestSparkPipelineOptions.class, (PipelineOptions)options);
            return new SparkRunnerDebugger(testSparkPipelineOptions);
        }
        SparkPipelineOptions sparkPipelineOptions = (SparkPipelineOptions)PipelineOptionsValidator.validate(SparkPipelineOptions.class, (PipelineOptions)options);
        return new SparkRunnerDebugger(sparkPipelineOptions);
    }

    public @UnknownKeyFor @NonNull @Initialized SparkPipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        SparkNativePipelineVisitor visitor;
        boolean isStreaming;
        boolean bl = isStreaming = this.options.isStreaming() || ((TestSparkPipelineOptions)this.options.as(TestSparkPipelineOptions.class)).isForceStreaming();
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"beam_fn_api")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary((Pipeline)pipeline);
        }
        JavaSparkContext jsc = SparkContextFactory.getSparkContext((SparkPipelineOptions)pipeline.getOptions().as(SparkPipelineOptions.class));
        JavaStreamingContext jssc = new JavaStreamingContext(jsc, new Duration(1000L));
        SparkRunner.initAccumulators(this.options, jsc);
        TransformTranslator.Translator translator = new TransformTranslator.Translator();
        if (isStreaming) {
            StreamingTransformTranslator.Translator streamingTranslator = new StreamingTransformTranslator.Translator(translator);
            EvaluationContext ctxt = new EvaluationContext(jsc, pipeline, this.options, jssc);
            visitor = new SparkNativePipelineVisitor(streamingTranslator, ctxt);
        } else {
            EvaluationContext ctxt = new EvaluationContext(jsc, pipeline, this.options, jssc);
            visitor = new SparkNativePipelineVisitor(translator, ctxt);
        }
        pipeline.traverseTopologically((Pipeline.PipelineVisitor)visitor);
        SparkContextFactory.stopSparkContext(jsc);
        String debugString = visitor.getDebugString();
        LOG.info("Translated Native Spark pipeline:\n{}", (Object)debugString);
        return new DebugSparkPipelineResult(debugString);
    }

    public static class DebugSparkPipelineResult
    extends SparkPipelineResult {
        private final @UnknownKeyFor @NonNull @Initialized String debugString;

        DebugSparkPipelineResult(@UnknownKeyFor @NonNull @Initialized String debugString) {
            super(null, null);
            this.debugString = debugString;
        }

        @UnknownKeyFor @NonNull @Initialized String getDebugString() {
            return this.debugString;
        }

        @Override
        protected void stop() {
        }

        @Override
        protected // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized PipelineResult.State awaitTermination(@UnknownKeyFor @NonNull @Initialized org.joda.time.Duration duration) throws @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
            return PipelineResult.State.DONE;
        }
    }
}

