/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class MetricOptions {
    public static final ConfigOption<String> REPORTERS_LIST = ConfigOptions.key("metrics.reporters").stringType().noDefaultValue().withDescription("An optional list of reporter names. If configured, only reporters whose name matches any of the names in the list will be started. Otherwise, all reporters that could be found in the configuration will be started.");
    public static final ConfigOption<String> REPORTER_CLASS = ConfigOptions.key("metrics.reporter.<name>.class").stringType().noDefaultValue().withDescription("The reporter class to use for the reporter named <name>.");
    public static final ConfigOption<Duration> REPORTER_INTERVAL = ConfigOptions.key("metrics.reporter.<name>.interval").durationType().defaultValue(Duration.ofSeconds(10L)).withDescription("The reporter interval to use for the reporter named <name>.");
    public static final ConfigOption<String> REPORTER_CONFIG_PARAMETER = ConfigOptions.key("metrics.reporter.<name>.<parameter>").stringType().noDefaultValue().withDescription("Configures the parameter <parameter> for the reporter named <name>.");
    public static final ConfigOption<String> SCOPE_DELIMITER = ConfigOptions.key("metrics.scope.delimiter").stringType().defaultValue(".").withDescription("Delimiter used to assemble the metric identifier.");
    public static final ConfigOption<String> SCOPE_NAMING_JM = ConfigOptions.key("metrics.scope.jm").stringType().defaultValue("<host>.jobmanager").withDescription("Defines the scope format string that is applied to all metrics scoped to a JobManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TM = ConfigOptions.key("metrics.scope.tm").stringType().defaultValue("<host>.taskmanager.<tm_id>").withDescription("Defines the scope format string that is applied to all metrics scoped to a TaskManager.");
    public static final ConfigOption<String> SCOPE_NAMING_JM_JOB = ConfigOptions.key("metrics.scope.jm.job").stringType().defaultValue("<host>.jobmanager.<job_name>").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a JobManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TM_JOB = ConfigOptions.key("metrics.scope.tm.job").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>").withDescription("Defines the scope format string that is applied to all metrics scoped to a job on a TaskManager.");
    public static final ConfigOption<String> SCOPE_NAMING_TASK = ConfigOptions.key("metrics.scope.task").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<task_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to a task.");
    public static final ConfigOption<String> SCOPE_NAMING_OPERATOR = ConfigOptions.key("metrics.scope.operator").stringType().defaultValue("<host>.taskmanager.<tm_id>.<job_name>.<operator_name>.<subtask_index>").withDescription("Defines the scope format string that is applied to all metrics scoped to an operator.");
    public static final ConfigOption<Long> LATENCY_INTERVAL = ConfigOptions.key("metrics.latency.interval").longType().defaultValue(0L).withDescription("Defines the interval at which latency tracking marks are emitted from the sources. Disables latency tracking if set to 0 or a negative value. Enabling this feature can significantly impact the performance of the cluster.");
    public static final ConfigOption<String> LATENCY_SOURCE_GRANULARITY = ConfigOptions.key("metrics.latency.granularity").stringType().defaultValue("operator").withDescription(Description.builder().text("Defines the granularity of latency metrics. Accepted values are:").list(TextElement.text("single - Track latency without differentiating between sources and subtasks."), TextElement.text("operator - Track latency while differentiating between sources, but not subtasks."), TextElement.text("subtask - Track latency while differentiating between sources and subtasks.")).build());
    public static final ConfigOption<Integer> LATENCY_HISTORY_SIZE = ConfigOptions.key("metrics.latency.history-size").intType().defaultValue(128).withDescription("Defines the number of measured latencies to maintain at each operator.");
    public static final ConfigOption<Boolean> SYSTEM_RESOURCE_METRICS = ConfigOptions.key("metrics.system-resource").booleanType().defaultValue(false).withDescription("Flag indicating whether Flink should report system resource metrics such as machine's CPU, memory or network usage.");
    public static final ConfigOption<Long> SYSTEM_RESOURCE_METRICS_PROBING_INTERVAL = ConfigOptions.key("metrics.system-resource-probing-interval").longType().defaultValue(5000L).withDescription("Interval between probing of system resource metrics specified in milliseconds. Has an effect only when '" + SYSTEM_RESOURCE_METRICS.key() + "' is enabled.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> QUERY_SERVICE_PORT = ConfigOptions.key("metrics.internal.query-service.port").stringType().defaultValue("0").withDescription("The port range used for Flink's internal metric query service. Accepts a list of ports (\u201c50100,50101\u201d), ranges(\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple Flink components are running on the same machine. Per default Flink will pick a random port.");
    public static final ConfigOption<Integer> QUERY_SERVICE_THREAD_PRIORITY = ConfigOptions.key("metrics.internal.query-service.thread-priority").intType().defaultValue(1).withDescription("The thread priority used for Flink's internal metric query service. The thread is created by Akka's thread pool executor. The range of the priority is from 1 (MIN_PRIORITY) to 10 (MAX_PRIORITY). Warning, increasing this value may bring the main Flink components down.");
    public static final ConfigOption<Long> METRIC_FETCHER_UPDATE_INTERVAL = ConfigOptions.key("metrics.fetcher.update-interval").longType().defaultValue(10000L).withDescription("Update interval for the metric fetcher used by the web UI in milliseconds. Decrease this value for faster updating metrics. Increase this value if the metric fetcher causes too much load. Setting this value to 0 disables the metric fetching completely.");
    public static final ConfigOption<List<JobStatusMetrics>> JOB_STATUS_METRICS = ConfigOptions.key("metrics.job.status.enable").enumType(JobStatusMetrics.class).asList().defaultValues((JobStatusMetrics[])new JobStatusMetrics[]{JobStatusMetrics.CURRENT_TIME}).withDescription("The selection of job status metrics that should be reported.");

    private MetricOptions() {
    }

    public static final class JobStatusMetricsSettings {
        private final boolean stateMetricsEnabled;
        private final boolean currentTimeMetricsEnabled;
        private final boolean totalTimeMetricsEnabled;

        private JobStatusMetricsSettings(boolean stateMetricsEnabled, boolean currentTimeMetricsEnabled, boolean totalTimeMetricsEnabled) {
            this.stateMetricsEnabled = stateMetricsEnabled;
            this.currentTimeMetricsEnabled = currentTimeMetricsEnabled;
            this.totalTimeMetricsEnabled = totalTimeMetricsEnabled;
        }

        public boolean isStateMetricsEnabled() {
            return this.stateMetricsEnabled;
        }

        public boolean isCurrentTimeMetricsEnabled() {
            return this.currentTimeMetricsEnabled;
        }

        public boolean isTotalTimeMetricsEnabled() {
            return this.totalTimeMetricsEnabled;
        }

        public static JobStatusMetricsSettings fromConfiguration(Configuration configuration) {
            List<JobStatusMetrics> jobStatusMetrics = configuration.get(JOB_STATUS_METRICS);
            boolean stateMetricsEnabled = false;
            boolean currentTimeMetricsEnabled = false;
            boolean totalTimeMetricsEnabled = false;
            for (JobStatusMetrics jobStatusMetric : jobStatusMetrics) {
                switch (jobStatusMetric) {
                    case STATE: {
                        stateMetricsEnabled = true;
                        break;
                    }
                    case CURRENT_TIME: {
                        currentTimeMetricsEnabled = true;
                        break;
                    }
                    case TOTAL_TIME: {
                        totalTimeMetricsEnabled = true;
                    }
                }
            }
            return new JobStatusMetricsSettings(stateMetricsEnabled, currentTimeMetricsEnabled, totalTimeMetricsEnabled);
        }
    }

    public static enum JobStatusMetrics implements DescribedEnum
    {
        STATE("For a given state, return 1 if the job is currently in that state, otherwise return 0."),
        CURRENT_TIME("For a given state, if the job is currently in that state, return the time since the job transitioned into that state, otherwise return 0."),
        TOTAL_TIME("For a given state, return how much time the job has spent in that state in total.");

        private final String description;

        private JobStatusMetrics(String description) {
            this.description = description;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

