/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private boolean ignoreNaN = false;

    public void setIgnoreNaN(boolean bl) {
        this.ignoreNaN = bl;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression != this) {
            return expression;
        }
        if (this.getNumberOfArguments() == 1) {
            int n = this.argument[0].getCardinality();
            TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
            if (!Cardinality.allowsMany(n) && typeHierarchy.isSubType(this.argument[0].getItemType(typeHierarchy), Type.NUMBER_TYPE)) {
                return this.argument[0];
            }
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        AtomicValue atomicValue2;
        SequenceIterator sequenceIterator;
        boolean bl;
        boolean bl2;
        Serializable serializable;
        block24: {
            serializable = this.getAtomicComparer(1, xPathContext);
            bl2 = false;
            bl = false;
            if (this.operation == 3) {
                serializable = new DescendingComparer((Comparator)((Object)serializable));
            }
            sequenceIterator = this.argument[0].iterate(xPathContext);
            do {
                if ((atomicValue2 = (AtomicValue)sequenceIterator.next()) == null) {
                    return null;
                }
                if (atomicValue2 instanceof UntypedAtomicValue) {
                    try {
                        atomicValue2 = new DoubleValue(Value.stringToNumber(atomicValue2.getStringValueCS()));
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.dynamicError("Failure converting " + Err.wrap(atomicValue2.getStringValueCS()) + " to a number", "FORG0001", xPathContext);
                    }
                } else if (atomicValue2 instanceof DoubleValue) {
                    bl2 = true;
                } else if (atomicValue2 instanceof FloatValue) {
                    bl = true;
                }
                if (!(atomicValue2 instanceof NumericValue) || !((NumericValue)atomicValue2).isNaN()) break block24;
            } while (this.ignoreNaN);
            return atomicValue2;
        }
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            AtomicValue atomicValue3 = atomicValue;
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue3 = new DoubleValue(Value.stringToNumber(atomicValue.getStringValueCS()));
                    bl2 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    this.dynamicError("Failure converting " + Err.wrap(atomicValue.getStringValueCS()) + " to a number", "FORG0001", xPathContext);
                }
            } else if (atomicValue3 instanceof DoubleValue) {
                bl2 = true;
            } else if (atomicValue3 instanceof FloatValue) {
                bl = true;
            }
            if (atomicValue3 instanceof NumericValue && ((NumericValue)atomicValue3).isNaN()) {
                if (this.ignoreNaN) continue;
                return atomicValue3;
            }
            try {
                if (serializable.compare(atomicValue3, atomicValue2) >= 0) continue;
                atomicValue2 = atomicValue3;
            }
            catch (ClassCastException classCastException) {
                TypeHierarchy typeHierarchy = xPathContext.getNamePool().getTypeHierarchy();
                this.typeError("Cannot compare " + atomicValue2.getItemType(typeHierarchy) + " with " + atomicValue3.getItemType(typeHierarchy), "FORG0006", xPathContext);
                return null;
            }
        }
        if (bl2 && !(atomicValue2 instanceof DoubleValue)) {
            atomicValue2 = atomicValue2.convert(517, xPathContext);
        } else if (bl && !(atomicValue2 instanceof FloatValue)) {
            atomicValue2 = atomicValue2.convert(516, xPathContext);
        }
        return atomicValue2;
    }
}

