/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;

public class EdgeHelper {
    public static Edge relabelEdge(Graph graph, Edge oldEdge, Object newId, String newLabel) {
        Vertex outVertex = oldEdge.getVertex(Direction.OUT);
        Vertex inVertex = oldEdge.getVertex(Direction.IN);
        Edge newEdge = graph.addEdge(newId, outVertex, inVertex, newLabel);
        ElementHelper.copyProperties(oldEdge, newEdge);
        graph.removeEdge(oldEdge);
        return newEdge;
    }

    public static void relabelEdges(Graph graph, Iterable<Edge> oldEdges, String newLabel) {
        for (Edge oldEdge : oldEdges) {
            Vertex outVertex = oldEdge.getVertex(Direction.OUT);
            Vertex inVertex = oldEdge.getVertex(Direction.IN);
            Edge newEdge = graph.addEdge(null, outVertex, inVertex, newLabel);
            ElementHelper.copyProperties(oldEdge, newEdge);
            graph.removeEdge(oldEdge);
        }
    }

    public static Vertex getOther(Edge edge, Vertex vertex) {
        Vertex temp = edge.getVertex(Direction.IN);
        if (temp.equals(vertex)) {
            return edge.getVertex(Direction.OUT);
        }
        return temp;
    }
}

