/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.sql.engine.util.CompositePublisher;

public class SortingCompositePublisher<T>
extends CompositePublisher<T> {
    private final Comparator<T> comp;
    private final int prefetch;

    public SortingCompositePublisher(Collection<? extends Flow.Publisher<T>> publishers, Comparator<T> comp, int prefetch) {
        super(publishers);
        this.comp = comp;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> downstream) {
        this.subscribe(new OrderedMergeCompositeSubscription<T>(downstream, this.comp, this.prefetch, this.publishers.size()), downstream);
    }

    public static class OrderedMergeCompositeSubscription<T>
    extends CompositePublisher.CompositeSubscription<T> {
        private static final Object DONE = new Object();
        private static final VarHandle ERROR;
        private static final VarHandle CANCELLED;
        private static final VarHandle REQUESTED;
        private final AtomicInteger guardCntr = new AtomicInteger();
        private final OrderedMergeSubscriber<T>[] subscribers;
        private final Comparator<? super T> comp;
        private final Object[] values;
        private Throwable error;
        private boolean cancelled;
        private long requested;
        private long emitted;

        public OrderedMergeCompositeSubscription(Flow.Subscriber<? super T> downstream, Comparator<? super T> comp, int prefetch, int cnt) {
            super(downstream);
            this.comp = comp;
            this.subscribers = new OrderedMergeSubscriber[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.subscribers[i] = new OrderedMergeSubscriber(this, prefetch);
            }
            this.values = new Object[cnt];
        }

        @Override
        public void subscribe(Collection<? extends Flow.Publisher<? extends T>> sources) {
            int i = 0;
            for (Flow.Publisher<T> publisher : sources) {
                publisher.subscribe(this.subscribers[i++]);
            }
        }

        @Override
        public void request(long n) {
            long next;
            long current;
            do {
                if ((next = (current = REQUESTED.getAcquire(this)) + n) >= 0L) continue;
                next = Long.MAX_VALUE;
            } while (!REQUESTED.compareAndSet(this, current, next));
            this.drain();
        }

        @Override
        public void cancel() {
            if (CANCELLED.compareAndSet(this, false, true)) {
                for (OrderedMergeSubscriber<T> inner : this.subscribers) {
                    inner.cancel();
                }
                if (this.guardCntr.getAndIncrement() == 0) {
                    Arrays.fill(this.values, null);
                    for (OrderedMergeSubscriber<T> inner : this.subscribers) {
                        inner.queue.clear();
                    }
                }
            }
        }

        private void onInnerError(OrderedMergeSubscriber<T> sender, Throwable ex) {
            this.updateError(ex);
            sender.done = true;
            this.drain();
        }

        private void updateError(Throwable throwable) {
            Throwable next;
            Throwable current;
            do {
                if ((current = ERROR.getAcquire(this)) == null) {
                    next = throwable;
                    continue;
                }
                next = new Throwable();
                next.addSuppressed(current);
                next.addSuppressed(throwable);
            } while (!ERROR.compareAndSet(this, current, next));
        }

        private void drain() {
            if (this.guardCntr.getAndIncrement() != 0) {
                return;
            }
            Flow.Subscriber downstream = this.downstream;
            OrderedMergeSubscriber<T>[] subscribers = this.subscribers;
            int subsCnt = subscribers.length;
            Object[] values = this.values;
            long emitted = this.emitted;
            do {
                long requested = REQUESTED.getAcquire(this);
                while (true) {
                    if (CANCELLED.getAcquire(this)) {
                        Arrays.fill(values, null);
                        for (OrderedMergeSubscriber<T> inner : subscribers) {
                            inner.queue.clear();
                        }
                        return;
                    }
                    int completed = 0;
                    boolean waitResponse = false;
                    for (int i = 0; i < subsCnt; ++i) {
                        Object obj = values[i];
                        if (obj == DONE) {
                            ++completed;
                            continue;
                        }
                        if (obj != null) continue;
                        boolean innerDone = subscribers[i].done;
                        obj = subscribers[i].queue.poll();
                        if (obj != null) {
                            values[i] = obj;
                            continue;
                        }
                        if (innerDone) {
                            values[i] = DONE;
                            ++completed;
                            continue;
                        }
                        waitResponse = true;
                        break;
                    }
                    if (completed == subsCnt) {
                        Throwable ex = ERROR.getAcquire(this);
                        if (ex == null) {
                            downstream.onComplete();
                        } else {
                            downstream.onError(ex);
                        }
                        return;
                    }
                    if (waitResponse || emitted == requested) break;
                    Object min = null;
                    int minIndex = -1;
                    for (int i = 0; i < values.length; ++i) {
                        Object obj = values[i];
                        if (obj == DONE || min != null && this.comp.compare(min, obj) <= 0) continue;
                        min = obj;
                        minIndex = i;
                    }
                    values[minIndex] = null;
                    downstream.onNext(min);
                    ++emitted;
                    subscribers[minIndex].request(1L);
                }
                this.emitted = emitted;
            } while (this.guardCntr.decrementAndGet() != 0);
        }

        static {
            MethodHandles.Lookup lk = MethodHandles.lookup();
            try {
                ERROR = lk.findVarHandle(OrderedMergeCompositeSubscription.class, "error", Throwable.class);
                CANCELLED = lk.findVarHandle(OrderedMergeCompositeSubscription.class, "cancelled", Boolean.TYPE);
                REQUESTED = lk.findVarHandle(OrderedMergeCompositeSubscription.class, "requested", Long.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new InternalError(ex);
            }
        }

        private static final class OrderedMergeSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T>,
        Flow.Subscription {
            private final OrderedMergeCompositeSubscription<T> parent;
            private final int prefetch;
            private final int limit;
            private final Queue<T> queue;
            private int consumed;
            private volatile boolean done;

            OrderedMergeSubscriber(OrderedMergeCompositeSubscription<T> parent, int prefetch) {
                this.parent = parent;
                this.prefetch = Math.max(1, prefetch);
                this.limit = this.prefetch - (this.prefetch >> 2);
                this.queue = new ConcurrentLinkedQueue<T>();
            }

            @Override
            public void onSubscribe(Flow.Subscription s) {
                if (this.compareAndSet(null, s)) {
                    s.request(this.prefetch);
                } else {
                    s.cancel();
                }
            }

            @Override
            public void onNext(T item) {
                this.queue.offer(item);
                this.parent.drain();
            }

            @Override
            public void onError(Throwable throwable) {
                this.parent.onInnerError(this, throwable);
            }

            @Override
            public void onComplete() {
                this.done = true;
                this.parent.drain();
            }

            @Override
            public void request(long n) {
                int c = this.consumed + 1;
                if (c == this.limit) {
                    this.consumed = 0;
                    Flow.Subscription subscription = (Flow.Subscription)this.get();
                    if (subscription != this) {
                        subscription.request(c);
                    }
                } else {
                    this.consumed = c;
                }
            }

            @Override
            public void cancel() {
                Flow.Subscription subscription = this.getAndSet(this);
                if (subscription != null && subscription != this) {
                    subscription.cancel();
                }
            }
        }
    }
}

