/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.Optional;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.configuration.ColumnView;
import org.apache.ignite.internal.schema.configuration.ConfigurationToSchemaDescriptorConverter;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.mapping.ColumnMapping;
import org.apache.ignite.lang.IgniteStringFormatter;

public class SchemaUtils {
    public static SchemaDescriptor prepareSchemaDescriptor(int schemaVer, TableView tableView) {
        return ConfigurationToSchemaDescriptorConverter.convert(schemaVer, tableView);
    }

    public static ColumnMapper columnMapper(SchemaDescriptor oldDesc, NamedListView<? extends ColumnView> oldTblColumns, SchemaDescriptor newDesc, NamedListView<? extends ColumnView> newTblColumns) {
        ColumnMapper mapper = null;
        assert (newTblColumns.size() >= oldTblColumns.size());
        for (int i = 0; i < newTblColumns.size(); ++i) {
            ColumnView newColView = (ColumnView)newTblColumns.get(i);
            if (newColView == null) continue;
            if (i < oldTblColumns.size()) {
                ColumnView oldColView = (ColumnView)oldTblColumns.get(i);
                Column newCol = newDesc.column(newColView.name());
                Column oldCol = oldDesc.column(oldColView.name());
                if (newCol.schemaIndex() == oldCol.schemaIndex()) continue;
                if (mapper == null) {
                    mapper = ColumnMapping.createMapper(newDesc);
                }
                mapper.add(newCol.schemaIndex(), oldCol.schemaIndex());
                continue;
            }
            Column newCol = newDesc.column(newColView.name());
            assert (!newDesc.isKeyColumn(newCol.schemaIndex()));
            if (mapper == null) {
                mapper = ColumnMapping.createMapper(newDesc);
            }
            mapper.add(newCol);
        }
        Optional<Column> droppedKeyCol = newTblColumns.namedListKeys().stream().filter(k -> newTblColumns.get(k) == null).map(oldDesc::column).filter(c -> oldDesc.isKeyColumn(c.schemaIndex())).findAny();
        assert (droppedKeyCol.isEmpty()) : IgniteStringFormatter.format((String)"Dropping of key column is forbidden: [schemaVer={}, col={}]", (Object[])new Object[]{newDesc.version(), droppedKeyCol.get()});
        return mapper == null ? ColumnMapping.identityMapping() : mapper;
    }

    public static boolean equalSchemas(SchemaDescriptor exp, SchemaDescriptor actual) {
        if (exp.keyColumns().length() != actual.keyColumns().length() || exp.valueColumns().length() != actual.valueColumns().length()) {
            return false;
        }
        for (int i = 0; i < exp.length(); ++i) {
            if (exp.column(i).equals(actual.column(i))) continue;
            return false;
        }
        return true;
    }
}

