/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.ConfigurationValue;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.ConfigurationTreeWrapper;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.TypeUtils;
import org.apache.ignite.internal.configuration.asm.DirectProxyAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.direct.DirectPropertyProxy;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class ConfigurationAsmGenerator {
    private static final Constructor<?> DYNAMIC_CONFIGURATION_CTOR;
    public static final Method LAMBDA_METAFACTORY;
    private static final Method ACCEPT;
    private static final Method VISIT_LEAF;
    private static final Method VISIT_INNER;
    private static final Method VISIT_NAMED;
    private static final Method UNWRAP;
    private static final Method DESCEND;
    private static final Method COPY;
    private static final Method INTERNAL_ID;
    private static final Method DYNAMIC_CONFIGURATION_ADD_MTD;
    private static final Method REQUIRE_NON_NULL;
    private static final Method CLASS_GET_NAME_MTD;
    private static final Method STRING_EQUALS_MTD;
    private static final Method POLYMORPHIC_TYPE_ID_MTD;
    private static final Method CONSTRUCT_DEFAULT_MTD;
    private static final Method REFRESH_VALUE_MTD;
    private static final Method ADD_MEMBER_MTD;
    private static final Method REMOVE_MEMBER_MTD;
    private static final Method SPECIFIC_NODE_MTD;
    private static final Method SPECIFIC_CONFIG_TREE_MTD;
    private static final Method ADD_DEFAULTS_MTD;
    private static final Method SET_INJECTED_NAME_FIELD_VALUE_MTD;
    private static final Method CURRENT_VALUE_MTD;
    private static final Method IS_REMOVED_FROM_NAMED_LIST_MTD;
    private static final Method IS_POLYMORPHIC_MTD;
    private static final Method INTERNAL_SCHEMA_TYPES_MTD;
    private static final String CONVERT_MTD_NAME = "convert";
    private static final String CONSTRUCT_MTD_NAME = "construct";
    private static final String INTERNAL_CONFIG_TYPES_FIELD_NAME = "_internalConfigTypes";
    private final Map<Class<?>, SchemaClassesInfo> schemasInfo = new HashMap();
    private final ClassGenerator generator = ClassGenerator.classGenerator((ClassLoader)this.getClass().getClassLoader());

    public synchronized InnerNode instantiateNode(Class<?> schemaClass) {
        SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
        assert (info != null && info.nodeClass != null) : schemaClass;
        try {
            Constructor<? extends InnerNode> constructor = info.nodeClass.getConstructor(new Class[0]);
            assert (constructor.canAccess(null));
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized DynamicConfiguration<?, ?> instantiateCfg(RootKey<?, ?> rootKey, DynamicConfigurationChanger changer) {
        SchemaClassesInfo info = this.schemasInfo.get(rootKey.schemaClass());
        assert (info != null && info.cfgImplClass != null);
        try {
            Constructor<DynamicConfiguration<?, ?>> constructor = info.cfgImplClass.getConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            assert (constructor.canAccess(null));
            return constructor.newInstance(Collections.emptyList(), rootKey.key(), rootKey, changer, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void compileRootSchema(Class<?> rootSchemaClass, Map<Class<?>, Set<Class<?>>> internalSchemaExtensions, Map<Class<?>, Set<Class<?>>> polymorphicSchemaExtensions) {
        if (this.schemasInfo.containsKey(rootSchemaClass)) {
            return;
        }
        ArrayDeque compileQueue = new ArrayDeque();
        compileQueue.add(rootSchemaClass);
        this.schemasInfo.put(rootSchemaClass, new SchemaClassesInfo(rootSchemaClass));
        HashSet<Class> schemas = new HashSet<Class>();
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        while (!compileQueue.isEmpty()) {
            Object subSchemaClass;
            Class schemaClass = (Class)compileQueue.poll();
            assert (schemaClass.isAnnotationPresent(ConfigurationRoot.class) || schemaClass.isAnnotationPresent(Config.class) || ConfigurationUtil.isPolymorphicConfig(schemaClass)) : schemaClass + " is not properly annotated";
            assert (this.schemasInfo.containsKey(schemaClass)) : schemaClass;
            Set<Class<?>> internalExtensions = internalSchemaExtensions.getOrDefault(schemaClass, Set.of());
            Set<Class<?>> polymorphicExtensions = polymorphicSchemaExtensions.getOrDefault(schemaClass, Set.of());
            assert (internalExtensions.isEmpty() || polymorphicExtensions.isEmpty()) : "Internal and polymorphic extensions are not allowed at the same time: " + schemaClass;
            if (ConfigurationUtil.isPolymorphicConfig(schemaClass) && polymorphicExtensions.isEmpty()) {
                throw new IllegalArgumentException(schemaClass + " is polymorphic but polymorphic extensions are absent");
            }
            Class schemaSuperClass = schemaClass.getSuperclass();
            List schemaFields = schemaSuperClass.isAnnotationPresent(AbstractConfiguration.class) ? CollectionUtils.concat((List[])new List[]{ConfigurationUtil.schemaFields(schemaClass), ConfigurationUtil.schemaFields(schemaSuperClass)}) : ConfigurationUtil.schemaFields(schemaClass);
            Collection<Field> internalExtensionsFields = ConfigurationUtil.extensionsFields(internalExtensions, true);
            Collection<Field> polymorphicExtensionsFields = ConfigurationUtil.extensionsFields(polymorphicExtensions, false);
            Field internalIdField = this.internalIdField(schemaClass, internalExtensions);
            for (Field field : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalExtensionsFields, polymorphicExtensionsFields})) {
                if (!ConfigurationUtil.isConfigValue(field) && !ConfigurationUtil.isNamedConfigValue(field) || this.schemasInfo.containsKey(subSchemaClass = field.getType())) continue;
                compileQueue.offer((Class<?>)subSchemaClass);
                this.schemasInfo.put((Class<?>)subSchemaClass, new SchemaClassesInfo((Class<?>)subSchemaClass));
            }
            for (Class clazz : polymorphicExtensions) {
                this.schemasInfo.put(clazz, new SchemaClassesInfo(clazz));
            }
            schemas.add(schemaClass);
            ClassDefinition innerNodeClassDef = this.createNodeClass(schemaClass, internalExtensions, polymorphicExtensions, schemaFields, internalExtensionsFields, polymorphicExtensionsFields, internalIdField);
            classDefs.add(innerNodeClassDef);
            ClassDefinition classDefinition = this.createCfgImplClass(schemaClass, internalExtensions, polymorphicExtensions, schemaFields, internalExtensionsFields, polymorphicExtensionsFields, internalIdField);
            classDefs.add(classDefinition);
            subSchemaClass = polymorphicExtensions.iterator();
            while (subSchemaClass.hasNext()) {
                Class polymorphicExtension = (Class)subSchemaClass.next();
                Collection polymorphicFields = polymorphicExtensionsFields.stream().filter(f -> f.getDeclaringClass() == polymorphicExtension).collect(Collectors.toList());
                classDefs.add(this.createPolymorphicExtensionNodeClass(schemaClass, polymorphicExtension, innerNodeClassDef, schemaFields, polymorphicFields, internalIdField));
                classDefs.add(this.createPolymorphicExtensionCfgImplClass(schemaClass, polymorphicExtension, classDefinition, schemaFields, polymorphicFields, internalIdField));
            }
            ClassDefinition directProxyClassDef = new DirectProxyAsmGenerator(this, schemaClass, internalExtensions, schemaFields, internalExtensionsFields, internalIdField).generate();
            classDefs.add(directProxyClassDef);
        }
        Map definedClasses = this.generator.defineClasses(classDefs);
        for (Class schemaClass : schemas) {
            SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
            info.nodeClass = (Class)definedClasses.get(info.nodeClassName);
            info.cfgImplClass = (Class)definedClasses.get(info.cfgImplClassName);
        }
    }

    synchronized SchemaClassesInfo schemaInfo(Class<?> schemaClass) {
        return this.schemasInfo.get(schemaClass);
    }

    @Nullable
    private Field internalIdField(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        List internalIdFields = Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).map(Class::getDeclaredFields).flatMap(Arrays::stream).filter(ConfigurationUtil::isInternalId).collect(Collectors.toList());
        if (internalIdFields.isEmpty()) {
            return null;
        }
        assert (internalIdFields.size() == 1) : internalIdFields;
        return (Field)internalIdFields.get(0);
    }

    private ClassDefinition createNodeClass(Class<?> schemaClass, Set<Class<?>> internalExtensions, Set<Class<?>> polymorphicExtensions, List<Field> schemaFields, Collection<Field> internalFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.nodeClassName), ParameterizedType.type(InnerNode.class), ConfigurationAsmGenerator.nodeClassInterfaces(schemaClass, internalExtensions));
        HashMap specFields = new HashMap();
        int i = 0;
        for (Class clazz : CollectionUtils.concat((Collection[])new Collection[]{List.of(schemaClass), internalExtensions, polymorphicExtensions})) {
            specFields.put(clazz, classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_spec" + i++, clazz));
        }
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        FieldDefinition injectedNameFieldDef = null;
        for (Object schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields, polymorphicFields})) {
            String fieldName = ConfigurationAsmGenerator.fieldName((Field)schemaField);
            FieldDefinition fieldDef = this.addNodeField(classDef, (Field)schemaField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
            if (ConfigurationUtil.isPolymorphicId((Field)schemaField)) {
                polymorphicTypeIdFieldDef = fieldDef;
                continue;
            }
            if (!ConfigurationUtil.isInjectedName((Field)schemaField)) continue;
            injectedNameFieldDef = fieldDef;
        }
        ConfigurationAsmGenerator.addNodeSchemaTypeMethod(classDef, schemaClass, polymorphicExtensions, polymorphicTypeIdFieldDef);
        FieldDefinition internalSchemaTypesFieldDef = null;
        if (!internalExtensions.isEmpty()) {
            internalSchemaTypesFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_" + INTERNAL_SCHEMA_TYPES_MTD.getName(), Class[].class);
        }
        this.addNodeConstructor(classDef, specFields, fieldDefs, schemaFields, internalFields, polymorphicFields, internalExtensions, internalSchemaTypesFieldDef);
        if (internalIdField != null) {
            this.addNodeInternalIdMethod(classDef, internalIdField);
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields})) {
            String fieldName = schemaField.getName();
            FieldDefinition fieldDef = (FieldDefinition)fieldDefs.get(fieldName);
            this.addNodeViewMethod(classDef, schemaField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDef), null);
            if (ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) continue;
            MethodDefinition changeMtd0 = this.addNodeChangeMethod(classDef, schemaField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, fieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, fieldDef), null);
            ConfigurationAsmGenerator.addNodeChangeBridgeMethod(classDef, SchemaClassesInfo.changeClassName(schemaField.getDeclaringClass()), changeMtd0);
        }
        Map<Class<?>, List<Field>> polymorphicFieldsByExtension = Map.of();
        MethodDefinition changePolymorphicTypeIdMtd = null;
        if (!polymorphicExtensions.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : schemaClass.getName();
            this.addNodeSpecificNodeMethod(classDef, polymorphicExtensions, polymorphicTypeIdFieldDef);
            changePolymorphicTypeIdMtd = this.addNodeChangePolymorphicTypeIdMethod(classDef, fieldDefs, polymorphicExtensions, polymorphicFields, polymorphicTypeIdFieldDef);
            this.addNodeConvertMethods(classDef, schemaClass, polymorphicExtensions, changePolymorphicTypeIdMtd);
            polymorphicFieldsByExtension = new LinkedHashMap();
            for (Class<?> polymorphicExtension : polymorphicExtensions) {
                polymorphicFieldsByExtension.put(polymorphicExtension, polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList()));
            }
        }
        ConfigurationAsmGenerator.addNodeTraverseChildrenMethod(classDef, schemaClass, fieldDefs, schemaFields, internalFields, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        ConfigurationAsmGenerator.addNodeTraverseChildMethod(classDef, fieldDefs, schemaFields, internalFields, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        this.addNodeConstructMethod(classDef, fieldDefs, schemaFields, internalFields, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef, changePolymorphicTypeIdMtd);
        ConfigurationAsmGenerator.addNodeConstructDefaultMethod(schemaClass, classDef, specFields, fieldDefs, schemaFields, internalFields, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        if (injectedNameFieldDef != null) {
            this.addInjectedNameFieldMethods(classDef, injectedNameFieldDef);
        }
        if (polymorphicTypeIdFieldDef != null) {
            ConfigurationAsmGenerator.addIsPolymorphicMethod(classDef);
        }
        if (internalSchemaTypesFieldDef != null) {
            ConfigurationAsmGenerator.addInternalSchemaTypesMethod(classDef, internalSchemaTypesFieldDef);
        }
        if (schemaClass.getSuperclass().isAnnotationPresent(AbstractConfiguration.class)) {
            ConfigurationAsmGenerator.addIsExtendAbstractConfigurationMethod(classDef);
        }
        return classDef;
    }

    private static void addNodeSchemaTypeMethod(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition schemaTypeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaType", ParameterizedType.type(Class.class), new Parameter[0]);
        BytecodeBlock mtdBody = schemaTypeMtd.getBody();
        if (polymorphicExtensions.isEmpty()) {
            mtdBody.append((BytecodeNode)BytecodeExpressions.constantClass(schemaClass)).retObject();
        } else {
            assert (polymorphicTypeIdFieldDef != null) : classDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(schemaTypeMtd, polymorphicTypeIdFieldDef);
            for (Class<?> polymorphicExtension : polymorphicExtensions) {
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.constantClass(polymorphicExtension).ret());
            }
            mtdBody.append((BytecodeNode)switchBuilderTypeId.build());
        }
    }

    private FieldDefinition addNodeField(ClassDefinition classDef, Field schemaField, String fieldName) {
        ParameterizedType nodeFieldType;
        Class<?> schemaFieldClass = schemaField.getType();
        if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) {
            nodeFieldType = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldClass));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaFieldClass).nodeClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.type(NamedListNode.class);
        } else {
            throw new IllegalArgumentException("Unsupported field: " + schemaField);
        }
        return classDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, nodeFieldType);
    }

    private void addNodeConstructor(ClassDefinition classDef, Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Collection<Field> schemaFields, Collection<Field> internalFields, Collection<Field> polymorphicFields, Set<Class<?>> internalExtensions, @Nullable FieldDefinition internalSchemaTypesFieldDef) {
        MethodDefinition ctor = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[0]);
        BytecodeBlock ctorBody = ctor.getBody();
        ctorBody.append((BytecodeNode)ctor.getThis()).invokeConstructor(InnerNode.class, new Class[0]);
        for (Map.Entry<Class<?>, FieldDefinition> e : specFields.entrySet()) {
            ctorBody.append((BytecodeNode)ctor.getThis().setField(e.getValue(), BytecodeExpressions.newInstance(e.getKey(), (BytecodeExpression[])new BytecodeExpression[0])));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields, polymorphicFields})) {
            if (!ConfigurationUtil.isNamedConfigValue(schemaField)) continue;
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, this.newNamedListNode(schemaField), fieldDef));
        }
        if (!internalExtensions.isEmpty()) {
            assert (internalSchemaTypesFieldDef != null) : classDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initInternalSchemaTypesField = new BytecodeBlock();
            initInternalSchemaTypesField.append((BytecodeNode)tmpVar.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (int)internalExtensions.size())));
            int i = 0;
            for (Class<?> extension : internalExtensions) {
                initInternalSchemaTypesField.append((BytecodeNode)BytecodeExpressions.set((BytecodeExpression)tmpVar, (BytecodeExpression)BytecodeExpressions.constantInt((int)i++), (BytecodeExpression)BytecodeExpressions.constantClass(extension)));
            }
            initInternalSchemaTypesField.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, (BytecodeExpression)tmpVar, internalSchemaTypesFieldDef));
            ctorBody.append((BytecodeNode)initInternalSchemaTypesField);
        }
        ctorBody.ret();
    }

    private void addNodeInternalIdMethod(ClassDefinition classDef, Field schemaField) {
        MethodDefinition internalIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), schemaField.getName(), ParameterizedType.type(UUID.class), new Parameter[0]);
        internalIdMtd.getBody().append((BytecodeNode)internalIdMtd.getThis().invoke(INTERNAL_ID, new BytecodeExpression[0])).retObject();
    }

    private void addNodeViewMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Class<?> schemaFieldType = schemaField.getType();
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaFieldType);
        ParameterizedType returnType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.viewClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListView.class) : ParameterizedType.type(schemaFieldType));
        String fieldName = schemaField.getName();
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        bytecodeBlock.append((BytecodeNode)getFieldCodeFun.apply(viewMtd));
        if (schemaFieldType.isPrimitive()) {
            bytecodeBlock.invokeVirtual(ConfigurationAsmGenerator.box(schemaFieldType), schemaFieldType.getSimpleName() + "Value", schemaFieldType, new Class[0]);
        } else if (schemaFieldType.isArray()) {
            bytecodeBlock.invokeVirtual(schemaFieldType, "clone", Object.class, new Class[0]).checkCast(schemaFieldType);
        } else if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            bytecodeBlock.invokeVirtual(SPECIFIC_NODE_MTD);
        }
        bytecodeBlock.ret(schemaFieldType);
        if (getPolymorphicTypeIdFieldFun != null) {
            assert (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass())) : schemaField;
            BytecodeExpression getPolymorphicTypeIdFieldValue = getPolymorphicTypeIdFieldFun.apply(viewMtd);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(schemaField.getDeclaringClass());
            viewMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)BytecodeExpressions.constantString((String)polymorphicInstanceId).invoke(STRING_EQUALS_MTD, new BytecodeExpression[]{getPolymorphicTypeIdFieldValue}))).ifTrue((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, getPolymorphicTypeIdFieldValue)).ifFalse((BytecodeNode)bytecodeBlock));
        } else {
            viewMtd.getBody().append((BytecodeNode)bytecodeBlock);
        }
    }

    private MethodDefinition addNodeChangeMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, BiFunction<MethodDefinition, BytecodeExpression, BytecodeExpression> setFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Object newValue;
        Class<?> schemaFieldType = schemaField.getType();
        MethodDefinition changeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(schemaField.getName()), classDef.getType(), new Parameter[]{Parameter.arg((String)"change", (ParameterizedType)(ConfigurationUtil.isValue(schemaField) ? ParameterizedType.type(schemaFieldType) : ParameterizedType.type(Consumer.class)))});
        Variable changeVar = changeMtd.getScope().getVariable("change");
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        if (!schemaFieldType.isPrimitive()) {
            bytecodeBlock.append((BytecodeNode)BytecodeExpressions.invokeStatic((Method)REQUIRE_NON_NULL, (BytecodeExpression[])new BytecodeExpression[]{changeVar, BytecodeExpressions.constantString((String)"change")}));
        }
        if (ConfigurationUtil.isValue(schemaField)) {
            if (schemaFieldType.isPrimitive()) {
                ParameterizedType type = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldType));
                newValue = BytecodeExpressions.invokeStatic((ParameterizedType)type, (String)"valueOf", (ParameterizedType)type, Collections.singleton(changeVar));
            } else {
                newValue = schemaFieldType.isArray() ? changeVar.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType) : changeVar;
            }
            bytecodeBlock.append((BytecodeNode)setFieldCodeFun.apply(changeMtd, (BytecodeExpression)newValue));
        } else {
            if (ConfigurationUtil.isConfigValue(schemaField)) {
                newValue = this.newOrCopyNodeField(schemaField, getFieldCodeFun.apply(changeMtd));
            } else {
                assert (ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
                newValue = this.copyNodeField(schemaField, getFieldCodeFun.apply(changeMtd));
            }
            bytecodeBlock.append((BytecodeNode)setFieldCodeFun.apply(changeMtd, (BytecodeExpression)newValue));
            BytecodeExpression getFieldCode = getFieldCodeFun.apply(changeMtd);
            if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
                getFieldCode = getFieldCode.invoke(SPECIFIC_NODE_MTD, new BytecodeExpression[0]);
            }
            bytecodeBlock.append((BytecodeNode)changeVar.invoke(ACCEPT, new BytecodeExpression[]{getFieldCode}));
        }
        bytecodeBlock.append((BytecodeNode)changeMtd.getThis()).retObject();
        if (getPolymorphicTypeIdFieldFun != null) {
            assert (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass())) : schemaField;
            BytecodeExpression getPolymorphicTypeIdFieldValue = getPolymorphicTypeIdFieldFun.apply(changeMtd);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(schemaField.getDeclaringClass());
            changeMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.not((BytecodeExpression)BytecodeExpressions.constantString((String)polymorphicInstanceId).invoke(STRING_EQUALS_MTD, new BytecodeExpression[]{getPolymorphicTypeIdFieldValue}))).ifTrue((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, getPolymorphicTypeIdFieldValue)).ifFalse((BytecodeNode)bytecodeBlock));
        } else {
            changeMtd.getBody().append((BytecodeNode)bytecodeBlock);
        }
        return changeMtd;
    }

    private static void addNodeChangeBridgeMethod(ClassDefinition classDef, String changeClassName, MethodDefinition changeMtd) {
        MethodDefinition bridgeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC, Access.SYNTHETIC, Access.BRIDGE), changeMtd.getName(), ParameterizedType.typeFromJavaClassName((String)changeClassName), (Collection)changeMtd.getParameters());
        Variable changeVar = bridgeMtd.getScope().getVariable("change");
        BytecodeExpression invokeChangeMtd = bridgeMtd.getThis().invoke(changeMtd, List.of(changeVar));
        bridgeMtd.getBody().append((BytecodeNode)invokeChangeMtd).retObject();
    }

    private static void addNodeTraverseChildrenMethod(ClassDefinition classDef, Class<?> schemaClass, Map<String, FieldDefinition> fieldDefs, List<Field> schemaFields, Collection<Field> internalFields, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildrenMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChildren", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = traverseChildrenMtd.getBody();
        for (Field schemaField : schemaFields) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            mtdBody.append((BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildrenMtd, schemaField, fieldDefs.get(schemaField.getName())).pop());
        }
        if (!internalFields.isEmpty()) {
            BytecodeBlock includeInternalBlock = new BytecodeBlock();
            for (Field field : internalFields) {
                includeInternalBlock.append((BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildrenMtd, field, fieldDefs.get(field.getName())).pop());
            }
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)traverseChildrenMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)includeInternalBlock));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : schemaClass.getName();
            assert (ConfigurationUtil.isPolymorphicId(schemaFields.get(0))) : schemaClass.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildrenMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry entry : polymorphicFieldsByExtension.entrySet()) {
                BytecodeBlock codeBlock = new BytecodeBlock();
                for (Field polymorphicField : (List)entry.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    codeBlock.append((BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildrenMtd, polymorphicField, fieldDefs.get(fieldName)).pop());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId((Class)entry.getKey()), (BytecodeNode)codeBlock);
            }
            mtdBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)ConfigurationAsmGenerator.getThisFieldCode(traverseChildrenMtd, polymorphicTypeIdFieldDef))).ifTrue((BytecodeNode)switchBuilderTypeId.build()));
        }
        mtdBody.ret();
    }

    private static void addNodeTraverseChildMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Collection<Field> schemaFields, Collection<Field> internalFields, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChild", ParameterizedType.type(Object.class), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"visitor", (ParameterizedType)ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        Variable keyVar = traverseChildMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : schemaFields) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            switchBuilder.addCase(fieldName, (BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
        }
        if (!internalFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
            for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                switchBuilderAllFields.addCase(fieldName, (BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
            }
            traverseChildMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)traverseChildMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)switchBuilderAllFields.build()).ifFalse((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : classDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(traverseChildMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    switchBuilderPolymorphicExtension.addCase(polymorphicField.getName(), (BytecodeNode)ConfigurationAsmGenerator.invokeVisit(traverseChildMtd, polymorphicField, fieldDefs.get(fieldName)).retObject());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            traverseChildMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build());
        } else {
            traverseChildMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build());
        }
    }

    private static BytecodeBlock invokeVisit(MethodDefinition mtd, Field schemaField, FieldDefinition fieldDef) {
        Method visitMethod = ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) ? VISIT_LEAF : (ConfigurationUtil.isConfigValue(schemaField) ? VISIT_INNER : VISIT_NAMED);
        return new BytecodeBlock().append((BytecodeNode)mtd.getScope().getVariable("visitor").invoke(visitMethod, new BytecodeExpression[]{BytecodeExpressions.constantString((String)schemaField.getName()), mtd.getThis().getField(fieldDef)}));
    }

    private void addNodeConstructMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Collection<Field> schemaFields, Collection<Field> internalFields, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef, @Nullable MethodDefinition changePolymorphicTypeIdMtd) {
        MethodDefinition constructMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"src", (ParameterizedType)ParameterizedType.type(ConfigurationSource.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        Variable keyVar = constructMtd.getScope().getVariable("key");
        Variable srcVar = constructMtd.getScope().getVariable("src");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : schemaFields) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            if (ConfigurationUtil.isPolymorphicId(schemaField)) {
                BytecodeExpression getTypeIdFromSrcVar = BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)srcVar), (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()), (BytecodeExpression)srcVar.invoke(UNWRAP, new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)fieldDef.getType())}).cast(fieldDef.getType()));
                switchBuilder.addCase(fieldName, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)constructMtd.getThis()).append((BytecodeNode)getTypeIdFromSrcVar).invokeVirtual(changePolymorphicTypeIdMtd).ret());
                continue;
            }
            switchBuilder.addCase(fieldName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDef).ret());
        }
        if (!internalFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
            for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                switchBuilderAllFields.addCase(fieldName, (BytecodeNode)this.treatSourceForConstruct(constructMtd, schemaField, fieldDefs.get(fieldName)).ret());
            }
            constructMtd.getBody().append((BytecodeNode)new IfStatement().condition((BytecodeNode)constructMtd.getScope().getVariable("includeInternal")).ifTrue((BytecodeNode)switchBuilderAllFields.build()).ifFalse((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build())).ret();
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : classDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    FieldDefinition fieldDef = fieldDefs.get(fieldName);
                    switchBuilderPolymorphicExtension.addCase(polymorphicField.getName(), (BytecodeNode)this.treatSourceForConstruct(constructMtd, polymorphicField, fieldDef).ret());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            constructMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build()).ret();
        } else {
            constructMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()).ret();
        }
    }

    private static void addNodeConstructDefaultMethod(Class<?> schemaClass, ClassDefinition classDef, Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Collection<Field> schemaFields, Collection<Field> internalFields, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition constructDfltMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "constructDefault", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", String.class)}).addException(NoSuchElementException.class);
        Variable keyVar = constructDfltMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructDfltMtd.getScope()).expression((BytecodeExpression)keyVar);
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField) || !ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            String fieldName = schemaField.getName();
            if (ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.hasDefault(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) && !schemaField.getAnnotation(PolymorphicId.class).hasDefault()) {
                switchBuilder.addCase(fieldName, (BytecodeNode)new BytecodeBlock().ret());
                continue;
            }
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            Class<?> fieldType = schemaField.getDeclaringClass();
            FieldDefinition specFieldDef = fieldType.isAnnotationPresent(AbstractConfiguration.class) ? specFields.get(schemaClass) : specFields.get(fieldType);
            switchBuilder.addCase(fieldName, (BytecodeNode)ConfigurationAsmGenerator.addNodeConstructDefault(constructDfltMtd, schemaField, fieldDef, specFieldDef).ret());
        }
        if (!polymorphicFieldsByExtension.isEmpty()) {
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructDfltMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructDfltMtd.getScope()).expression((BytecodeExpression)keyVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar}));
                for (Field polymorphicField : e.getValue()) {
                    if (!ConfigurationUtil.isValue(polymorphicField)) continue;
                    if (!ConfigurationUtil.hasDefault(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(polymorphicField.getName(), (BytecodeNode)new BytecodeBlock().ret());
                        continue;
                    }
                    FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
                    FieldDefinition specFieldDef = specFields.get(polymorphicField.getDeclaringClass());
                    switchBuilderPolymorphicExtension.addCase(polymorphicField.getName(), (BytecodeNode)ConfigurationAsmGenerator.addNodeConstructDefault(constructDfltMtd, polymorphicField, fieldDef, specFieldDef).ret());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), (BytecodeNode)switchBuilderPolymorphicExtension.build());
            }
            constructDfltMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)new BytecodeBlock()).build()).append((BytecodeNode)switchBuilderTypeId.build()).ret();
        } else {
            constructDfltMtd.getBody().append((BytecodeNode)switchBuilder.defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(NoSuchElementException.class, new BytecodeExpression[]{keyVar})).build()).ret();
        }
    }

    private BytecodeExpression newOrCopyNodeField(Field schemaField, BytecodeExpression getFieldCode) {
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).nodeClassName);
        return BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)getFieldCode), (BytecodeExpression)BytecodeExpressions.newInstance((ParameterizedType)nodeType, (BytecodeExpression[])new BytecodeExpression[0]), (BytecodeExpression)this.copyNodeField(schemaField, getFieldCode));
    }

    private BytecodeExpression copyNodeField(Field schemaField, BytecodeExpression getFieldCode) {
        ParameterizedType nodeType = ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListNode.class) : ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).nodeClassName);
        return getFieldCode.invoke(COPY, new BytecodeExpression[0]).cast(nodeType);
    }

    @NotNull
    private static BytecodeExpression newNamedListElementLambda(String nodeClassName) {
        return BytecodeExpressions.invokeDynamic((Method)LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[0]), new Handle(8, ConfigurationAsmGenerator.internalName(nodeClassName), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)nodeClassName).getAsmType(), (Type[])new Type[0])), (String)"get", (MethodType)MethodType.methodType(Supplier.class), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    private ClassDefinition createCfgImplClass(Class<?> schemaClass, Set<Class<?>> internalExtensions, Set<Class<?>> polymorphicExtensions, Collection<Field> schemaFields, Collection<Field> internalFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), ParameterizedType.type(DynamicConfiguration.class), this.configClassInterfaces(schemaClass, internalExtensions));
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields, polymorphicFields})) {
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            FieldDefinition fieldDef = this.addConfigurationImplField(classDef, schemaField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
            if (!ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            polymorphicTypeIdFieldDef = fieldDef;
        }
        if (internalIdField != null) {
            String fieldName = internalIdField.getName();
            FieldDefinition fieldDef = this.addConfigurationImplField(classDef, internalIdField, fieldName);
            fieldDefs.put(fieldName, fieldDef);
        }
        FieldDefinition internalConfigTypesFieldDef = null;
        if (!internalExtensions.isEmpty()) {
            internalConfigTypesFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), INTERNAL_CONFIG_TYPES_FIELD_NAME, Class[].class);
        }
        this.addConfigurationImplConstructor(classDef, schemaClass, internalExtensions, fieldDefs, schemaFields, internalFields, polymorphicFields, internalIdField, internalConfigTypesFieldDef);
        this.addDirectProxyMethod(schemaClassInfo, classDef);
        if (internalIdField != null) {
            this.addConfigurationImplGetMethod(classDef, internalIdField, (FieldDefinition)fieldDefs.get(internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields})) {
            this.addConfigurationImplGetMethod(classDef, schemaField, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        ConfigurationAsmGenerator.addCfgImplConfigTypeMethod(classDef, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName));
        if (internalConfigTypesFieldDef != null) {
            ConfigurationAsmGenerator.addCfgImplInternalConfigTypesMethod(classDef, internalConfigTypesFieldDef);
        }
        if (!polymorphicExtensions.isEmpty()) {
            this.addCfgSpecificConfigTreeMethod(classDef, schemaClass, polymorphicExtensions, polymorphicTypeIdFieldDef);
            this.addCfgRemoveMembersMethod(classDef, schemaClass, polymorphicExtensions, fieldDefs, polymorphicFields, polymorphicTypeIdFieldDef);
            this.addCfgAddMembersMethod(classDef, schemaClass, polymorphicExtensions, fieldDefs, polymorphicFields, polymorphicTypeIdFieldDef);
            ConfigurationAsmGenerator.addCfgImplPolymorphicInstanceConfigTypeMethod(classDef, schemaClass, polymorphicExtensions, polymorphicTypeIdFieldDef);
        }
        return classDef;
    }

    private FieldDefinition addConfigurationImplField(ClassDefinition classDef, Field schemaField, String fieldName) {
        ParameterizedType fieldType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).cfgImplClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListConfiguration.class) : ParameterizedType.type(DynamicProperty.class));
        return classDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, fieldType);
    }

    private void addConfigurationImplConstructor(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> internalExtensions, Map<String, FieldDefinition> fieldDefs, Collection<Field> schemaFields, Collection<Field> internalFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField, @Nullable FieldDefinition internalConfigTypesFieldDef) {
        MethodDefinition ctor = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class), Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE)});
        Variable rootKeyVar = ctor.getScope().getVariable("rootKey");
        Variable changerVar = ctor.getScope().getVariable("changer");
        Variable listenOnlyVar = ctor.getScope().getVariable("listenOnly");
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        Variable thisVar = ctor.getThis();
        BytecodeBlock ctorBody = ctor.getBody().append((BytecodeNode)thisVar).append((BytecodeNode)ctor.getScope().getVariable("prefix")).append((BytecodeNode)ctor.getScope().getVariable("key")).append((BytecodeNode)rootKeyVar).append((BytecodeNode)changerVar).append((BytecodeNode)listenOnlyVar).invokeConstructor(DYNAMIC_CONFIGURATION_CTOR);
        BytecodeExpression thisKeysVar = thisVar.getField("keys", List.class);
        List<Object> internalIdFieldAsList = internalIdField == null ? Collections.emptyList() : List.of(internalIdField);
        int newIdx = 0;
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, internalFields, polymorphicFields, internalIdFieldAsList})) {
            BytecodeExpression newValue;
            String fieldName = schemaField.getName();
            if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) {
                newValue = BytecodeExpressions.newInstance(DynamicProperty.class, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)(ConfigurationUtil.isInjectedName(schemaField) ? "<injected_name>" : (ConfigurationUtil.isInternalId(schemaField) ? "<internal_id>" : schemaField.getName()))), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.constantBoolean((ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField) ? 1 : 0) != 0)});
            } else {
                SchemaClassesInfo fieldInfo = this.schemasInfo.get(schemaField.getType());
                ParameterizedType cfgImplParameterizedType = ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgImplClassName);
                if (ConfigurationUtil.isConfigValue(schemaField)) {
                    newValue = BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)fieldName), rootKeyVar, changerVar, listenOnlyVar});
                } else {
                    MethodDefinition newMtd = classDef.declareMethod(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.SYNTHETIC), "$new$" + newIdx++, ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName), new Parameter[]{Parameter.arg((String)"rootKey", RootKey.class), Parameter.arg((String)"changer", DynamicConfigurationChanger.class), Parameter.arg((String)"listenOnly", Boolean.TYPE), Parameter.arg((String)"prefix", List.class), Parameter.arg((String)"key", String.class)});
                    newValue = BytecodeExpressions.newInstance(NamedListConfiguration.class, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)fieldName), rootKeyVar, changerVar, listenOnlyVar, BytecodeExpressions.invokeDynamic((Method)LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), new Handle(6, ConfigurationAsmGenerator.internalName(schemaClassInfo.cfgImplClassName), newMtd.getName(), newMtd.getMethodDescriptor(), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)fieldInfo.cfgClassName).getAsmType(), (Type[])new Type[]{Type.getType(List.class), Type.getType(String.class)})), (String)"apply", BiFunction.class, (BytecodeExpression[])new BytecodeExpression[]{rootKeyVar, changerVar, listenOnlyVar}), DirectProxyAsmGenerator.newDirectProxyLambda(fieldInfo), BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{thisKeysVar, BytecodeExpressions.constantString((String)"any"), rootKeyVar, changerVar, BytecodeExpressions.constantBoolean((boolean)true)}).cast(ConfigurationProperty.class)});
                    newMtd.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)cfgImplParameterizedType, (BytecodeExpression[])new BytecodeExpression[]{newMtd.getScope().getVariable("prefix"), newMtd.getScope().getVariable("key"), newMtd.getScope().getVariable("rootKey"), newMtd.getScope().getVariable("changer"), newMtd.getScope().getVariable("listenOnly")})).retObject();
                }
            }
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append((BytecodeNode)thisVar.setField(fieldDef, newValue));
            if (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass()) || ConfigurationUtil.isInternalId(schemaField)) continue;
            ctorBody.append((BytecodeNode)thisVar.invoke(DYNAMIC_CONFIGURATION_ADD_MTD, new BytecodeExpression[]{thisVar.getField(fieldDef)}));
        }
        if (internalConfigTypesFieldDef != null) {
            assert (!internalExtensions.isEmpty()) : classDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initInternalConfigTypesField = new BytecodeBlock();
            initInternalConfigTypesField.append((BytecodeNode)tmpVar.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Class[].class), (int)internalExtensions.size())));
            int i = 0;
            for (Class<?> extension : internalExtensions) {
                initInternalConfigTypesField.append((BytecodeNode)BytecodeExpressions.set((BytecodeExpression)tmpVar, (BytecodeExpression)BytecodeExpressions.constantInt((int)i++), (BytecodeExpression)BytecodeExpressions.constantClass((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(extension)))));
            }
            initInternalConfigTypesField.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(ctor, (BytecodeExpression)tmpVar, internalConfigTypesFieldDef));
            ctorBody.append((BytecodeNode)initInternalConfigTypesField);
        }
        ctorBody.ret();
    }

    private void addDirectProxyMethod(SchemaClassesInfo schemaClassInfo, ClassDefinition classDef) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "directProxy", ParameterizedType.type(DirectPropertyProxy.class), new Parameter[0]);
        methodDef.getBody().append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.directProxyClassName), (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().invoke("keyPath", List.class, new BytecodeExpression[0]), methodDef.getThis().getField("changer", DynamicConfigurationChanger.class)}));
        methodDef.getBody().retObject();
    }

    private void addConfigurationImplGetMethod(ClassDefinition classDef, Field schemaField, FieldDefinition ... fieldDefs) {
        ParameterizedType returnType;
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        Class<?> schemaFieldType = schemaField.getType();
        String fieldName = schemaField.getName();
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaFieldType);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            returnType = ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            returnType = ParameterizedType.type(NamedConfigurationTree.class);
        } else {
            assert (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField)) : schemaField;
            returnType = ParameterizedType.type(ConfigurationValue.class);
        }
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock body = viewMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDefs));
        if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            body.invokeVirtual(SPECIFIC_CONFIG_TREE_MTD);
        }
        body.retObject();
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    @NotNull
    static String internalName(String className) {
        return className.replace('.', '/');
    }

    private static Class<?> box(Class<?> clazz) {
        Class<?> boxed = TypeUtils.boxed(clazz);
        return boxed == null ? clazz : boxed;
    }

    private static ParameterizedType[] nodeClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        ArrayList<ParameterizedType> res = new ArrayList<ParameterizedType>();
        for (Class cls : CollectionUtils.concat((Collection[])new Collection[]{List.of(schemaClass), schemaExtensions})) {
            res.add(ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.viewClassName(cls)));
            res.add(ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.changeClassName(cls)));
        }
        return (ParameterizedType[])res.toArray(ParameterizedType[]::new);
    }

    ParameterizedType[] configClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        List result = Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).map(cls -> ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(cls))).collect(Collectors.toCollection(ArrayList::new));
        return result.toArray(new ParameterizedType[0]);
    }

    private static void addCfgImplConfigTypeMethod(ClassDefinition classDef, ParameterizedType clazz) {
        classDef.declareMethod(EnumSet.of(Access.PUBLIC), "configType", ParameterizedType.type(Class.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantClass((ParameterizedType)clazz)).retObject();
    }

    private static void addCfgImplInternalConfigTypesMethod(ClassDefinition classDef, FieldDefinition internalConfigTypesDef) {
        MethodDefinition internalConfigTypesMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "internalConfigTypes", ParameterizedType.type(Class[].class), new Parameter[0]);
        internalConfigTypesMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(internalConfigTypesMtd, internalConfigTypesDef)).retObject();
    }

    private static void addCfgImplPolymorphicInstanceConfigTypeMethod(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition polymorphicInstanceConfigTypeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "polymorphicInstanceConfigType", ParameterizedType.type(Class.class), new Parameter[0]);
        Variable tmpStrVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(polymorphicInstanceConfigTypeMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.constantClass((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(polymorphicExtension))).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.nodeClassName(schemaClass));
        Variable tmpObjVar = polymorphicInstanceConfigTypeMtd.getScope().createTempVariable(Object.class);
        Variable thisVar = polymorphicInstanceConfigTypeMtd.getThis();
        polymorphicInstanceConfigTypeMtd.getBody().append((BytecodeNode)tmpObjVar.set(BytecodeExpressions.inlineIf((BytecodeExpression)thisVar.invoke(IS_REMOVED_FROM_NAMED_LIST_MTD, new BytecodeExpression[0]), (BytecodeExpression)thisVar.invoke(CURRENT_VALUE_MTD, new BytecodeExpression[0]), (BytecodeExpression)thisVar.invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0])))).append((BytecodeNode)tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private ClassDefinition createPolymorphicExtensionNodeClass(Class<?> schemaClass, Class<?> polymorphicExtension, ClassDefinition schemaInnerNodeClassDef, Collection<Field> schemaFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.schemasInfo.get(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.nodeClassName), ParameterizedType.type(Object.class), (ParameterizedType[])ArrayUtils.concat((Object[])ConfigurationAsmGenerator.nodeClassInterfaces(polymorphicExtension, Set.of()), (Object[])new ParameterizedType[]{ParameterizedType.type(ConstructableTreeNode.class)}));
        FieldDefinition parentInnerNodeFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.nodeClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"delegate", (ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.nodeClassName))});
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append((BytecodeNode)constructorMtd.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructorMtd.getThis().setField(parentInnerNodeFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = schemaInnerNodeClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (internalIdField != null) {
            this.addNodeViewMethod(classDef, internalIdField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef).invoke(INTERNAL_ID, new BytecodeExpression[0]), null);
        }
        for (Field field : schemaFields) {
            FieldDefinition schemaFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(field));
            this.addNodeViewMethod(classDef, field, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, schemaFieldDef), null);
            if (ConfigurationUtil.isPolymorphicId(field) || ConfigurationUtil.isInjectedName(field)) continue;
            MethodDefinition changeMtd0 = this.addNodeChangeMethod(classDef, field, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, schemaFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, schemaFieldDef), null);
            ConfigurationAsmGenerator.addNodeChangeBridgeMethod(classDef, schemaClassInfo.changeClassName, changeMtd0);
        }
        FieldDefinition polymorphicTypeIdFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.polymorphicIdField(schemaClass).getName());
        for (Field polymorphicField : polymorphicFields) {
            FieldDefinition polymorphicFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
            this.addNodeViewMethod(classDef, polymorphicField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicFieldDef), viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            MethodDefinition changeMtd0 = this.addNodeChangeMethod(classDef, polymorphicField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, polymorphicFieldDef), changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            ConfigurationAsmGenerator.addNodeChangeBridgeMethod(classDef, polymorphicExtensionClassInfo.changeClassName, changeMtd0);
        }
        ParameterizedType parameterizedType = ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName);
        MethodDefinition convertByChangeClassMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, parameterizedType, new Parameter[]{Parameter.arg((String)"changeClass", Class.class)});
        convertByChangeClassMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(convertByChangeClassMtd, parentInnerNodeFieldDef)).append((BytecodeNode)convertByChangeClassMtd.getScope().getVariable("changeClass")).invokeVirtual(schemaInnerNodeClassDef.getType(), CONVERT_MTD_NAME, parameterizedType, new ParameterizedType[]{ParameterizedType.type(Class.class)}).retObject();
        MethodDefinition convertByPolymorphicTypeIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, parameterizedType, new Parameter[]{Parameter.arg((String)"polymorphicTypeId", String.class)});
        convertByPolymorphicTypeIdMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(convertByPolymorphicTypeIdMtd, parentInnerNodeFieldDef)).append((BytecodeNode)convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId")).invokeVirtual(schemaInnerNodeClassDef.getType(), CONVERT_MTD_NAME, parameterizedType, new ParameterizedType[]{ParameterizedType.type(String.class)}).retObject();
        MethodDefinition constructMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"key", (ParameterizedType)ParameterizedType.type(String.class)), Parameter.arg((String)"src", (ParameterizedType)ParameterizedType.type(ConfigurationSource.class)), Parameter.arg((String)"includeInternal", (ParameterizedType)ParameterizedType.type(Boolean.TYPE))}).addException(NoSuchElementException.class);
        constructMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(constructMtd, parentInnerNodeFieldDef)).append((BytecodeNode)constructMtd.getScope().getVariable("key")).append((BytecodeNode)constructMtd.getScope().getVariable("src")).append((BytecodeNode)constructMtd.getScope().getVariable("includeInternal")).invokeVirtual(schemaInnerNodeClassDef.getType(), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(String.class), ParameterizedType.type(ConfigurationSource.class), ParameterizedType.type(Boolean.TYPE)}).ret();
        MethodDefinition copyMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "copy", ParameterizedType.type(ConstructableTreeNode.class), new Parameter[0]);
        copyMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(copyMtd, parentInnerNodeFieldDef)).invokeVirtual(schemaInnerNodeClassDef.getType(), "copy", ParameterizedType.type(ConstructableTreeNode.class), new ParameterizedType[0]).retObject();
        return classDef;
    }

    private ClassDefinition createPolymorphicExtensionCfgImplClass(Class<?> schemaClass, Class<?> polymorphicExtension, ClassDefinition schemaCfgImplClassDef, Collection<Field> schemaFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.schemasInfo.get(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.cfgImplClassName), ParameterizedType.type(ConfigurationTreeWrapper.class), this.configClassInterfaces(polymorphicExtension, Set.of()));
        FieldDefinition parentCfgImplFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgImplClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"delegate", (ParameterizedType)ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.cfgImplClassName))});
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append((BytecodeNode)constructorMtd.getThis()).append((BytecodeNode)delegateVar).invokeConstructor(ConfigurationTreeWrapper.class, new Class[]{ConfigurationTree.class}).append((BytecodeNode)constructorMtd.getThis().setField(parentCfgImplFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = schemaCfgImplClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (internalIdField != null) {
            this.addConfigurationImplGetMethod(classDef, internalIdField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(internalIdField.getName()));
        }
        for (Field schemaField : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, polymorphicFields})) {
            this.addConfigurationImplGetMethod(classDef, schemaField, parentCfgImplFieldDef, (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField)));
        }
        return classDef;
    }

    private void addNodeSpecificNodeMethod(ClassDefinition classDef, Set<Class<?>> polymorphicExtensions, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificNodeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_NODE_MTD.getName(), ParameterizedType.type(Object.class), new Parameter[0]);
        StringSwitchBuilder switchBuilder = ConfigurationAsmGenerator.typeIdSwitchBuilder(specificNodeMtd, polymorphicTypeIdFieldDef);
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.schemasInfo.get(polymorphicExtension);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{specificNodeMtd.getThis()}).ret());
        }
        specificNodeMtd.getBody().append((BytecodeNode)switchBuilder.build());
    }

    private void addNodeConvertMethods(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, MethodDefinition changePolymorphicTypeIdMtd) {
        SchemaClassesInfo schemaClassInfo = this.schemasInfo.get(schemaClass);
        MethodDefinition convertByChangeClassMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName), new Parameter[]{Parameter.arg((String)"changeClass", Class.class)});
        MethodDefinition convertByPolymorphicTypeIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName((String)schemaClassInfo.changeClassName), new Parameter[]{Parameter.arg((String)"polymorphicTypeId", String.class)});
        BytecodeExpression changeClassName = convertByChangeClassMtd.getScope().getVariable("changeClass").invoke(CLASS_GET_NAME_MTD, new BytecodeExpression[0]);
        StringSwitchBuilder switchByChangeClassBuilder = new StringSwitchBuilder(convertByChangeClassMtd.getScope()).expression(changeClassName).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, changeClassName));
        Variable polymorphicTypeId = convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId");
        StringSwitchBuilder switchByPolymorphicTypeIdBuilder = new StringSwitchBuilder(convertByPolymorphicTypeIdMtd.getScope()).expression((BytecodeExpression)polymorphicTypeId).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{polymorphicTypeId}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.schemasInfo.get(polymorphicExtension);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(polymorphicExtension);
            switchByChangeClassBuilder.addCase(polymorphicExtensionClassInfo.changeClassName, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.constantString((String)polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{convertByChangeClassMtd.getThis()})).retObject());
            switchByPolymorphicTypeIdBuilder.addCase(polymorphicInstanceId, (BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.constantString((String)polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append((BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)polymorphicExtensionClassInfo.nodeClassName), (BytecodeExpression[])new BytecodeExpression[]{convertByPolymorphicTypeIdMtd.getThis()})).retObject());
        }
        convertByChangeClassMtd.getBody().append((BytecodeNode)convertByChangeClassMtd.getThis()).append((BytecodeNode)switchByChangeClassBuilder.build()).ret();
        convertByPolymorphicTypeIdMtd.getBody().append((BytecodeNode)convertByPolymorphicTypeIdMtd.getThis()).append((BytecodeNode)switchByPolymorphicTypeIdBuilder.build()).ret();
    }

    private MethodDefinition addNodeChangePolymorphicTypeIdMethod(ClassDefinition classDef, Map<String, FieldDefinition> fieldDefs, Set<Class<?>> polymorphicExtensions, Collection<Field> polymorphicFields, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition changePolymorphicTypeIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(polymorphicTypeIdFieldDef.getName()), ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"typeId", String.class)});
        Variable typeIdVar = changePolymorphicTypeIdMtd.getScope().getVariable("typeId");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(changePolymorphicTypeIdMtd.getScope()).expression((BytecodeExpression)typeIdVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{typeIdVar}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            Collection resetFields = polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock codeBlock = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, (BytecodeExpression)typeIdVar, polymorphicTypeIdFieldDef));
            for (Field resetField : resetFields) {
                FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(resetField));
                if (ConfigurationUtil.isValue(resetField) || ConfigurationUtil.isConfigValue(resetField)) {
                    codeBlock.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, BytecodeExpressions.constantNull((ParameterizedType)fieldDef.getType()), fieldDef));
                    continue;
                }
                codeBlock.append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, this.newNamedListNode(resetField), fieldDef));
            }
            codeBlock.append((BytecodeNode)changePolymorphicTypeIdMtd.getThis()).invokeStatic(ADD_DEFAULTS_MTD);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)codeBlock);
        }
        changePolymorphicTypeIdMtd.getBody().append((BytecodeNode)typeIdVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(changePolymorphicTypeIdMtd, polymorphicTypeIdFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().invokeVirtual(STRING_EQUALS_MTD)).ifTrue((BytecodeNode)new BytecodeBlock().ret()).ifFalse((BytecodeNode)switchBuilder.build().ret()));
        return changePolymorphicTypeIdMtd;
    }

    private void addCfgSpecificConfigTreeMethod(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificConfigMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_CONFIG_TREE_MTD.getName(), ParameterizedType.type(ConfigurationTree.class), new Parameter[0]);
        Variable tmpStrVar = specificConfigMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(specificConfigMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)BytecodeExpressions.newInstance((ParameterizedType)ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(polymorphicExtension).cfgImplClassName), (BytecodeExpression[])new BytecodeExpression[]{specificConfigMtd.getThis()}).ret());
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaClass).nodeClassName);
        Variable tmpObjVar = specificConfigMtd.getScope().createTempVariable(Object.class);
        specificConfigMtd.getBody().append((BytecodeNode)tmpObjVar.set(specificConfigMtd.getThis().invoke(REFRESH_VALUE_MTD, new BytecodeExpression[0]))).append((BytecodeNode)tmpStrVar.set(tmpObjVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private void addCfgRemoveMembersMethod(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, Map<String, FieldDefinition> fieldDefs, Collection<Field> polymorphicFields, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "removeMembers", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"oldValue", (ParameterizedType)ParameterizedType.type(Object.class)), Parameter.arg((String)"members", (ParameterizedType)ParameterizedType.type(Map.class))});
        Variable oldValueVar = removeMembersMtd.getScope().getVariable("oldValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            Collection removeFields = polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field removeField : removeFields) {
                blockCode.append((BytecodeNode)removeMembersMtd.getThis()).append((BytecodeNode)membersVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(removeField)))).invokeVirtual(REMOVE_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaClass).nodeClassName);
        removeMembersMtd.getBody().append((BytecodeNode)tmpStrVar.set(oldValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private void addCfgAddMembersMethod(ClassDefinition classDef, Class<?> schemaClass, Set<Class<?>> polymorphicExtensions, Map<String, FieldDefinition> fieldDefs, Collection<Field> polymorphicFields, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition removeMembersMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "addMembers", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"newValue", (ParameterizedType)ParameterizedType.type(Object.class)), Parameter.arg((String)"members", (ParameterizedType)ParameterizedType.type(Map.class))});
        Variable newValueVar = removeMembersMtd.getScope().getVariable("newValue");
        Variable membersVar = removeMembersMtd.getScope().getVariable("members");
        Variable tmpStrVar = removeMembersMtd.getScope().createTempVariable(String.class);
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(removeMembersMtd.getScope()).expression((BytecodeExpression)tmpStrVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, new BytecodeExpression[]{tmpStrVar}));
        for (Class<?> polymorphicExtension : polymorphicExtensions) {
            Collection addFields = polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock blockCode = new BytecodeBlock();
            for (Field addField : addFields) {
                blockCode.append((BytecodeNode)removeMembersMtd.getThis()).append((BytecodeNode)membersVar).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(removeMembersMtd, fieldDefs.get(ConfigurationAsmGenerator.fieldName(addField)))).invokeVirtual(ADD_MEMBER_MTD);
            }
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), (BytecodeNode)blockCode);
        }
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaClass).nodeClassName);
        removeMembersMtd.getBody().append((BytecodeNode)tmpStrVar.set(newValueVar.cast(nodeType).getField(polymorphicTypeIdFieldDef.getName(), String.class))).append((BytecodeNode)switchBuilder.build()).ret();
    }

    private BytecodeBlock treatSourceForConstruct(MethodDefinition constructMtd, Field schemaField, FieldDefinition schemaFieldDef) {
        BytecodeBlock codeBlock = new BytecodeBlock();
        Variable thisVar = constructMtd.getThis();
        Variable srcVar = constructMtd.getScope().getVariable("src");
        if (ConfigurationUtil.isValue(schemaField)) {
            codeBlock.append((BytecodeNode)thisVar.setField(schemaFieldDef, BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)srcVar), (BytecodeExpression)BytecodeExpressions.constantNull((ParameterizedType)schemaFieldDef.getType()), (BytecodeExpression)srcVar.invoke(UNWRAP, new BytecodeExpression[]{BytecodeExpressions.constantClass((ParameterizedType)schemaFieldDef.getType())}).cast(schemaFieldDef.getType()))));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            BytecodeExpression setField;
            ParameterizedType fieldDefType = schemaFieldDef.getType();
            if (ConfigurationUtil.isPolymorphicConfig(schemaField.getType())) {
                Field polymorphicIdField = ConfigurationAsmGenerator.polymorphicIdField(schemaField.getType());
                assert (polymorphicIdField != null) : schemaField.getType().getName();
                BytecodeExpression thisField = ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef);
                Variable tmpStrVar = constructMtd.getScope().createTempVariable(String.class);
                BytecodeBlock copyWithChange = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisField.invoke(COPY, new BytecodeExpression[0]).cast(fieldDefType), schemaFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmpStrVar)).ifTrue((BytecodeNode)thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, new BytecodeExpression[]{tmpStrVar})));
                BytecodeBlock newInstanceWithChange = new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.newInstance((ParameterizedType)fieldDefType, (BytecodeExpression[])new BytecodeExpression[0]), schemaFieldDef)).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmpStrVar)).ifTrue((BytecodeNode)thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, new BytecodeExpression[]{tmpStrVar})).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisField.invoke(CONSTRUCT_DEFAULT_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)polymorphicIdField.getName())})).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)thisField.getField(polymorphicIdField.getName(), String.class))).ifTrue((BytecodeNode)ConfigurationAsmGenerator.throwException(IllegalStateException.class, BytecodeExpressions.constantString((String)this.polymorphicTypeNotDefinedErrorMessage(polymorphicIdField)))))));
                setField = new BytecodeBlock().append((BytecodeNode)tmpStrVar.set(srcVar.invoke(POLYMORPHIC_TYPE_ID_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)polymorphicIdField.getName())}))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)thisField)).ifTrue((BytecodeNode)newInstanceWithChange).ifFalse((BytecodeNode)copyWithChange));
            } else {
                BytecodeExpression newValue = this.newOrCopyNodeField(schemaField, ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef));
                setField = ConfigurationAsmGenerator.setThisFieldCode(constructMtd, newValue, schemaFieldDef);
            }
            if (ConfigurationUtil.containsNameAnnotation(schemaField)) {
                setField = new BytecodeBlock().append((BytecodeNode)setField).append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef).invoke(SET_INJECTED_NAME_FIELD_VALUE_MTD, new BytecodeExpression[]{BytecodeExpressions.constantString((String)schemaField.getAnnotation(Name.class).value())}));
            }
            codeBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.constantNull((ParameterizedType)fieldDefType), schemaFieldDef)).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)setField).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{thisVar.getField(schemaFieldDef)}))));
        } else {
            codeBlock.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)srcVar)).ifTrue((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, this.newNamedListNode(schemaField), schemaFieldDef)).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisVar.getField(schemaFieldDef).invoke(COPY, new BytecodeExpression[0]).cast(schemaFieldDef.getType()), schemaFieldDef)).append((BytecodeNode)srcVar.invoke(DESCEND, new BytecodeExpression[]{thisVar.getField(schemaFieldDef)}))));
        }
        return codeBlock;
    }

    private String polymorphicTypeNotDefinedErrorMessage(Field polymorphicIdField) {
        return "Polymorphic configuration type is not defined: " + polymorphicIdField.getDeclaringClass().getName() + ". See @" + PolymorphicConfig.class.getSimpleName() + " documentation.";
    }

    private static BytecodeBlock addNodeConstructDefault(MethodDefinition constructDfltMtd, Field schemaField, FieldDefinition schemaFieldDef, FieldDefinition specFieldDef) {
        Variable thisVar = constructDfltMtd.getThis();
        BytecodeExpression defaultValue = thisVar.getField(specFieldDef).getField(schemaField);
        Class<?> schemaFieldType = schemaField.getType();
        if (schemaFieldType.isPrimitive()) {
            defaultValue = BytecodeExpressions.invokeStatic((ParameterizedType)schemaFieldDef.getType(), (String)"valueOf", (ParameterizedType)schemaFieldDef.getType(), Collections.singleton(defaultValue));
        }
        if (schemaFieldType.isArray()) {
            defaultValue = defaultValue.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType);
        }
        return new BytecodeBlock().append((BytecodeNode)thisVar.setField(schemaFieldDef, defaultValue));
    }

    private static BytecodeBlock throwException(Class<? extends Throwable> throwableClass, BytecodeExpression ... parameters) {
        return new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(throwableClass, (BytecodeExpression[])parameters)).throwObject();
    }

    private static String fieldName(Field f) {
        return ConfigurationUtil.isPolymorphicConfigInstance(f.getDeclaringClass()) ? f.getName() + "#" + ConfigurationUtil.polymorphicInstanceId(f.getDeclaringClass()) : f.getName();
    }

    private static StringSwitchBuilder typeIdSwitchBuilder(MethodDefinition mtdDef, FieldDefinition typeIdFieldDef) {
        BytecodeExpression typeIdVar = mtdDef.getThis().getField(typeIdFieldDef);
        return new StringSwitchBuilder(mtdDef.getScope()).expression(typeIdVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, typeIdVar));
    }

    private static BytecodeExpression getThisFieldCode(MethodDefinition mtdDef, FieldDefinition ... fieldDefs) {
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        BytecodeExpression getFieldCode = mtdDef.getThis().getField(fieldDefs[0]);
        for (int i = 1; i < fieldDefs.length; ++i) {
            getFieldCode = getFieldCode.getField(fieldDefs[i]);
        }
        return getFieldCode;
    }

    private static BytecodeExpression setThisFieldCode(MethodDefinition mtdDef, BytecodeExpression value, FieldDefinition ... fieldDefs) {
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        if (fieldDefs.length == 1) {
            return mtdDef.getThis().setField(fieldDefs[0], value);
        }
        BytecodeExpression getFieldCode = mtdDef.getThis().getField(fieldDefs[0]);
        for (int i = 1; i < fieldDefs.length - 1; ++i) {
            getFieldCode = getFieldCode.getField(fieldDefs[i]);
        }
        return getFieldCode.setField(fieldDefs[fieldDefs.length - 1], value);
    }

    @Nullable
    private static Field polymorphicIdField(Class<?> schemaClass) {
        assert (ConfigurationUtil.isPolymorphicConfig(schemaClass)) : schemaClass.getName();
        for (Field f : schemaClass.getDeclaredFields()) {
            if (!ConfigurationUtil.isPolymorphicId(f)) continue;
            return f;
        }
        return null;
    }

    private static String changeMethodName(String schemaField) {
        return "change" + ConfigurationAsmGenerator.capitalize(schemaField);
    }

    private BytecodeExpression newNamedListNode(Field schemaField) {
        assert (ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
        Class<?> fieldType = schemaField.getType();
        SchemaClassesInfo fieldClassNames = this.schemasInfo.get(fieldType);
        String syntheticKeyName = Arrays.stream(schemaField.getType().getDeclaredFields()).filter(ConfigurationUtil::isInjectedName).map(Field::getName).findFirst().orElse(schemaField.getAnnotation(NamedConfigValue.class).syntheticKeyName());
        return BytecodeExpressions.newInstance(NamedListNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)syntheticKeyName), ConfigurationAsmGenerator.newNamedListElementLambda(fieldClassNames.nodeClassName), ConfigurationUtil.isPolymorphicConfig(fieldType) ? BytecodeExpressions.constantString((String)ConfigurationAsmGenerator.polymorphicIdField(fieldType).getName()) : BytecodeExpressions.constantNull(String.class)});
    }

    private void addInjectedNameFieldMethods(ClassDefinition classDef, FieldDefinition injectedNameFieldDef) {
        MethodDefinition getInjectedNameFieldValueMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "getInjectedNameFieldValue", ParameterizedType.type(String.class), new Parameter[0]);
        getInjectedNameFieldValueMtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(getInjectedNameFieldValueMtd, injectedNameFieldDef)).retObject();
        MethodDefinition setInjectedNameFieldValueMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "setInjectedNameFieldValue", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"value", String.class)});
        Variable valueVar = setInjectedNameFieldValueMtd.getScope().getVariable("value");
        setInjectedNameFieldValueMtd.getBody().append((BytecodeNode)BytecodeExpressions.invokeStatic((Method)REQUIRE_NON_NULL, (BytecodeExpression[])new BytecodeExpression[]{valueVar, BytecodeExpressions.constantString((String)"value")})).append((BytecodeNode)ConfigurationAsmGenerator.setThisFieldCode(setInjectedNameFieldValueMtd, (BytecodeExpression)valueVar, injectedNameFieldDef)).ret();
    }

    private static void addIsPolymorphicMethod(ClassDefinition innerNodeClassDef) {
        MethodDefinition mtd = innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), IS_POLYMORPHIC_MTD.getName(), ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    private static void addInternalSchemaTypesMethod(ClassDefinition innerNodeClassDef, FieldDefinition internalSchemaTypesFieldDef) {
        MethodDefinition mtd = innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), INTERNAL_SCHEMA_TYPES_MTD.getName(), ParameterizedType.type(Class[].class), new Parameter[0]);
        mtd.getBody().append((BytecodeNode)ConfigurationAsmGenerator.getThisFieldCode(mtd, internalSchemaTypesFieldDef)).retObject();
    }

    private static void addIsExtendAbstractConfigurationMethod(ClassDefinition innerNodeClassDef) {
        MethodDefinition mtd = innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "extendsAbstractConfiguration", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    static {
        try {
            LAMBDA_METAFACTORY = LambdaMetafactory.class.getDeclaredMethod("metafactory", MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
            ACCEPT = Consumer.class.getDeclaredMethod("accept", Object.class);
            VISIT_LEAF = ConfigurationVisitor.class.getDeclaredMethod("visitLeafNode", String.class, Serializable.class);
            VISIT_INNER = ConfigurationVisitor.class.getDeclaredMethod("visitInnerNode", String.class, InnerNode.class);
            VISIT_NAMED = ConfigurationVisitor.class.getDeclaredMethod("visitNamedListNode", String.class, NamedListNode.class);
            UNWRAP = ConfigurationSource.class.getDeclaredMethod("unwrap", Class.class);
            DESCEND = ConfigurationSource.class.getDeclaredMethod("descend", ConstructableTreeNode.class);
            COPY = ConstructableTreeNode.class.getDeclaredMethod("copy", new Class[0]);
            INTERNAL_ID = InnerNode.class.getDeclaredMethod("internalId", new Class[0]);
            DYNAMIC_CONFIGURATION_CTOR = DynamicConfiguration.class.getDeclaredConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            DYNAMIC_CONFIGURATION_ADD_MTD = DynamicConfiguration.class.getDeclaredMethod("add", ConfigurationProperty.class);
            REQUIRE_NON_NULL = Objects.class.getDeclaredMethod("requireNonNull", Object.class, String.class);
            CLASS_GET_NAME_MTD = Class.class.getDeclaredMethod("getName", new Class[0]);
            STRING_EQUALS_MTD = String.class.getDeclaredMethod("equals", Object.class);
            POLYMORPHIC_TYPE_ID_MTD = ConfigurationSource.class.getDeclaredMethod("polymorphicTypeId", String.class);
            CONSTRUCT_DEFAULT_MTD = InnerNode.class.getDeclaredMethod("constructDefault", String.class);
            REFRESH_VALUE_MTD = ConfigurationNode.class.getDeclaredMethod("refreshValue", new Class[0]);
            ADD_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("addMember", Map.class, ConfigurationProperty.class);
            REMOVE_MEMBER_MTD = DynamicConfiguration.class.getDeclaredMethod("removeMember", Map.class, ConfigurationProperty.class);
            SPECIFIC_NODE_MTD = InnerNode.class.getDeclaredMethod("specificNode", new Class[0]);
            SPECIFIC_CONFIG_TREE_MTD = DynamicConfiguration.class.getDeclaredMethod("specificConfigTree", new Class[0]);
            ADD_DEFAULTS_MTD = ConfigurationUtil.class.getDeclaredMethod("addDefaults", InnerNode.class);
            SET_INJECTED_NAME_FIELD_VALUE_MTD = InnerNode.class.getDeclaredMethod("setInjectedNameFieldValue", String.class);
            CURRENT_VALUE_MTD = ConfigurationNode.class.getDeclaredMethod("currentValue", new Class[0]);
            IS_REMOVED_FROM_NAMED_LIST_MTD = DynamicConfiguration.class.getDeclaredMethod("isRemovedFromNamedList", new Class[0]);
            IS_POLYMORPHIC_MTD = InnerNode.class.getDeclaredMethod("isPolymorphic", new Class[0]);
            INTERNAL_SCHEMA_TYPES_MTD = InnerNode.class.getDeclaredMethod("internalSchemaTypes", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

