/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.sql.ClientColumnMetadata;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ResultSetMetadata;

class ClientResultSetMetadata
implements ResultSetMetadata {
    private final List<ColumnMetadata> columns;
    private final Map<String, Integer> columnIndices;

    public ClientResultSetMetadata(ClientMessageUnpacker unpacker) {
        int size = unpacker.unpackArrayHeader();
        assert (size > 0) : "ResultSetMetadata should not be empty.";
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(size);
        this.columnIndices = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            ClientColumnMetadata column = new ClientColumnMetadata(unpacker, columns);
            columns.add(column);
            this.columnIndices.put(column.name(), i);
        }
        this.columns = Collections.unmodifiableList(columns);
    }

    public List<ColumnMetadata> columns() {
        return this.columns;
    }

    public int indexOf(String columnName) {
        Integer index = this.columnIndices.get(columnName);
        return index == null ? -1 : index;
    }
}

