/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.manager.IgniteTables;

public class ClientTables
implements IgniteTables {
    private final ReliableChannel ch;

    public ClientTables(ReliableChannel ch) {
        this.ch = ch;
    }

    public List<Table> tables() {
        return ClientUtils.sync(this.tablesAsync());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.ch.serviceAsync(3, r -> {
            ClientMessageUnpacker in = r.in();
            int cnt = in.unpackMapHeader();
            ArrayList<ClientTable> res = new ArrayList<ClientTable>(cnt);
            for (int i = 0; i < cnt; ++i) {
                res.add(new ClientTable(this.ch, in.unpackUuid(), in.unpackString()));
            }
            return res;
        });
    }

    public Table table(String name) {
        return ClientUtils.sync(this.tableAsync(name));
    }

    public CompletableFuture<Table> tableAsync(String name) {
        Objects.requireNonNull(name);
        return this.ch.serviceAsync(4, w -> w.out().packString(name), r -> r.in().tryUnpackNil() ? null : new ClientTable(this.ch, r.in().unpackUuid(), name));
    }
}

