/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryFetchRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryFetchResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryMetadataRequest;

public class JdbcClientQueryCursorHandler
implements JdbcQueryCursorHandler {
    private final ClientChannel channel;

    public JdbcClientQueryCursorHandler(ClientChannel channel) {
        this.channel = channel;
    }

    public CompletableFuture<JdbcQueryFetchResult> fetchAsync(JdbcQueryFetchRequest req) {
        return this.channel.serviceAsync(35, w -> req.writeBinary(w.out()), r -> {
            JdbcQueryFetchResult res = new JdbcQueryFetchResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcQueryCloseResult> closeAsync(JdbcQueryCloseRequest req) {
        return this.channel.serviceAsync(37, w -> req.writeBinary(w.out()), r -> {
            JdbcQueryCloseResult res = new JdbcQueryCloseResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcMetaColumnsResult> queryMetadataAsync(JdbcQueryMetadataRequest req) {
        return this.channel.serviceAsync(42, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaColumnsResult res = new JdbcMetaColumnsResult();
            res.readBinary(r.in());
            return res;
        });
    }
}

