/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.TcpIgniteClient;
import org.apache.ignite.internal.jdbc.JdbcQueryExecuteResponse;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchExecuteResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcBatchPreparedStmntRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaColumnsResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaPrimaryKeysResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaSchemasResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcMetaTablesResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.jdbc.proto.event.Response;

public class JdbcClientQueryEventHandler
implements JdbcQueryEventHandler {
    private final TcpIgniteClient client;

    public JdbcClientQueryEventHandler(TcpIgniteClient client) {
        this.client = client;
    }

    public CompletableFuture<Response> queryAsync(JdbcQueryExecuteRequest req) {
        return this.client.sendRequestAsync(34, w -> req.writeBinary(w.out()), r -> {
            JdbcQueryExecuteResponse res = new JdbcQueryExecuteResponse(r.clientChannel());
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchAsync(JdbcBatchExecuteRequest req) {
        return this.client.sendRequestAsync(36, w -> req.writeBinary(w.out()), r -> {
            JdbcBatchExecuteResult res = new JdbcBatchExecuteResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcBatchExecuteResult> batchPrepStatementAsync(JdbcBatchPreparedStmntRequest req) {
        return this.client.sendRequestAsync(46, w -> req.writeBinary(w.out()), r -> {
            JdbcBatchExecuteResult res = new JdbcBatchExecuteResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcMetaTablesResult> tablesMetaAsync(JdbcMetaTablesRequest req) {
        return this.client.sendRequestAsync(38, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaTablesResult res = new JdbcMetaTablesResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcMetaColumnsResult> columnsMetaAsync(JdbcMetaColumnsRequest req) {
        return this.client.sendRequestAsync(39, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaColumnsResult res = new JdbcMetaColumnsResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcMetaSchemasResult> schemasMetaAsync(JdbcMetaSchemasRequest req) {
        return this.client.sendRequestAsync(40, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaSchemasResult res = new JdbcMetaSchemasResult();
            res.readBinary(r.in());
            return res;
        });
    }

    public CompletableFuture<JdbcMetaPrimaryKeysResult> primaryKeysMetaAsync(JdbcMetaPrimaryKeysRequest req) {
        return this.client.sendRequestAsync(41, w -> req.writeBinary(w.out()), r -> {
            JdbcMetaPrimaryKeysResult res = new JdbcMetaPrimaryKeysResult();
            res.readBinary(r.in());
            return res;
        });
    }
}

