/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.hlc;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Clock;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;

public class HybridClockImpl
implements HybridClock {
    private static final VarHandle LATEST_TIME;
    protected volatile HybridTimestamp latestTime = new HybridTimestamp(Clock.systemUTC().instant().toEpochMilli(), 0);

    @Override
    public HybridTimestamp now() {
        long currentTimeMillis;
        HybridTimestamp newLatestTime;
        HybridTimestamp latestTime;
        do {
            currentTimeMillis = Clock.systemUTC().instant().toEpochMilli();
        } while (!LATEST_TIME.compareAndSet(this, latestTime, newLatestTime = (latestTime = this.latestTime).getPhysical() >= currentTimeMillis ? latestTime.addTicks(1) : new HybridTimestamp(currentTimeMillis, 0)));
        return newLatestTime;
    }

    @Override
    public HybridTimestamp update(HybridTimestamp requestTime) {
        HybridTimestamp now;
        HybridTimestamp maxLatestTime;
        HybridTimestamp newLatestTime;
        HybridTimestamp latestTime;
        do {
            now = new HybridTimestamp(Clock.systemUTC().instant().toEpochMilli(), -1);
            latestTime = this.latestTime;
        } while (!LATEST_TIME.compareAndSet(this, latestTime, newLatestTime = (maxLatestTime = HybridTimestamp.max(now, requestTime, latestTime)).addTicks(1)));
        return newLatestTime;
    }

    public String toString() {
        return S.toString(HybridClock.class, this);
    }

    static {
        try {
            LATEST_TIME = MethodHandles.lookup().findVarHandle(HybridClockImpl.class, "latestTime", HybridTimestamp.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

