/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequestBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReplicaSafeTimeSyncRequestImpl
implements ReplicaSafeTimeSyncRequest {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private ReplicationGroupId groupId;
    private byte[] groupIdByteArray;

    private ReplicaSafeTimeSyncRequestImpl(ReplicationGroupId groupId, byte[] groupIdByteArray) {
        this.groupId = groupId;
        this.groupIdByteArray = groupIdByteArray;
    }

    byte[] groupIdByteArray() {
        return this.groupIdByteArray;
    }

    @Override
    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(ReplicaSafeTimeSyncRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReplicaSafeTimeSyncRequestImpl otherMessage = (ReplicaSafeTimeSyncRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId);
        return result;
    }

    public static ReplicaSafeTimeSyncRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject groupIdByteArraymo = marshaller.marshal((Object)this.groupId);
        usedDescriptors.addAll((IntCollection)groupIdByteArraymo.usedDescriptorIds());
        this.groupIdByteArray = groupIdByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.groupId = (ReplicationGroupId)marshaller.unmarshal(this.groupIdByteArray, descriptorsObj);
        this.groupIdByteArray = null;
    }

    private static class Builder
    implements ReplicaSafeTimeSyncRequestBuilder {
        private ReplicationGroupId groupId;
        private byte[] groupIdByteArray;

        private Builder() {
        }

        @Override
        public ReplicaSafeTimeSyncRequestBuilder groupId(ReplicationGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReplicaSafeTimeSyncRequestBuilder groupIdByteArray(byte[] groupIdByteArray) {
            this.groupIdByteArray = groupIdByteArray;
            return this;
        }

        @Override
        public ReplicationGroupId groupId() {
            return this.groupId;
        }

        @Override
        public byte[] groupIdByteArray() {
            return this.groupIdByteArray;
        }

        @Override
        public ReplicaSafeTimeSyncRequest build() {
            return new ReplicaSafeTimeSyncRequestImpl(this.groupId, this.groupIdByteArray);
        }
    }
}

