/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.notifications.ConfigurationContainer;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationEventImpl<VIEWT>
implements ConfigurationNotificationEvent<VIEWT> {
    @Nullable
    private final VIEWT oldValue;
    @Nullable
    private final VIEWT newValue;
    private final long storageRevision;
    private final ConfigurationContainer tail;

    ConfigurationNotificationEventImpl(@Nullable VIEWT oldValue, @Nullable VIEWT newValue, long storageRevision, ConfigurationContainer tail) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.storageRevision = storageRevision;
        this.tail = tail;
    }

    @Nullable
    public VIEWT oldValue() {
        return this.oldValue;
    }

    @Nullable
    public VIEWT newValue() {
        return this.newValue;
    }

    public long storageRevision() {
        return this.storageRevision;
    }

    @Nullable
    public <T extends ConfigurationProperty> T config(Class<T> configClass) {
        ConfigurationContainer container = this.findContainer(configClass);
        return (T)(container == null ? null : container.specificConfig());
    }

    @Nullable
    public String name(Class<? extends ConfigurationProperty> configClass) {
        ConfigurationContainer container = this.findContainer(configClass);
        return container == null ? null : container.name;
    }

    @Nullable
    private ConfigurationContainer findContainer(Class<?> configClass) {
        ConfigurationContainer curr = this.tail;
        while (curr != null) {
            if (configClass.isAssignableFrom(curr.configClass())) {
                return curr;
            }
            curr = curr.prev;
        }
        return null;
    }
}

