/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.DataRegionDirtyPages;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

class CheckpointDirtyPages {
    static final Comparator<FullPageId> DIRTY_PAGE_COMPARATOR = Comparator.comparingInt(FullPageId::groupId).thenComparingLong(FullPageId::effectivePageId);
    static final CheckpointDirtyPages EMPTY = new CheckpointDirtyPages(List.of());
    private final List<DataRegionDirtyPages<FullPageId[]>> dirtyPages;
    private final int dirtyPagesCount;

    public CheckpointDirtyPages(List<DataRegionDirtyPages<FullPageId[]>> dirtyPages) {
        assert (dirtyPages instanceof RandomAccess) : dirtyPages;
        this.dirtyPages = dirtyPages;
        this.dirtyPagesCount = dirtyPages.stream().mapToInt(pages -> ((FullPageId[])pages.dirtyPages).length).sum();
    }

    public int dirtyPagesCount() {
        return this.dirtyPagesCount;
    }

    public IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> toDirtyPageIdQueue() {
        List dirtyPageIds = this.dirtyPages.stream().map(pages -> new IgniteBiTuple((Object)pages.pageMemory, (Object)((FullPageId[])pages.dirtyPages))).collect(Collectors.toList());
        return new IgniteConcurrentMultiPairQueue(dirtyPageIds);
    }

    @Nullable
    public CheckpointDirtyPagesView getPartitionView(PersistentPageMemory pageMemory, int grpId, int partId) {
        for (int i = 0; i < this.dirtyPages.size(); ++i) {
            if (this.dirtyPages.get((int)i).pageMemory != pageMemory) continue;
            return this.getPartitionView(i, grpId, partId);
        }
        throw new IllegalArgumentException("Unknown PageMemory: " + pageMemory);
    }

    @Nullable
    private CheckpointDirtyPagesView getPartitionView(int dirtyPagesIdx, int grpId, int partId) {
        FullPageId startPageId = new FullPageId(PageIdUtils.pageId(partId, (byte)0, 0), grpId);
        FullPageId endPageId = new FullPageId(PageIdUtils.pageId(partId + 1, (byte)0, 0), grpId);
        FullPageId[] pageIds = (FullPageId[])this.dirtyPages.get((int)dirtyPagesIdx).dirtyPages;
        int fromIndex = Arrays.binarySearch(pageIds, startPageId, DIRTY_PAGE_COMPARATOR);
        int n = fromIndex = fromIndex >= 0 ? fromIndex : Math.min(pageIds.length - 1, -fromIndex - 1);
        if (!CheckpointDirtyPages.equalsByGroupAndPartition(startPageId, pageIds[fromIndex])) {
            return null;
        }
        int toIndex = Arrays.binarySearch(pageIds, fromIndex, pageIds.length, endPageId, DIRTY_PAGE_COMPARATOR);
        toIndex = toIndex >= 0 ? toIndex : -toIndex - 1;
        return new CheckpointDirtyPagesView(dirtyPagesIdx, fromIndex, toIndex);
    }

    @Nullable
    public CheckpointDirtyPagesView nextPartitionView(@Nullable CheckpointDirtyPagesView currentView) {
        int fromPosition;
        int regionIndex;
        assert (currentView == null || currentView.owner() == this) : currentView;
        if (this.dirtyPages.isEmpty()) {
            return null;
        }
        if (currentView == null) {
            regionIndex = 0;
            fromPosition = 0;
        } else {
            regionIndex = currentView.needsNextRegion() ? currentView.regionIndex + 1 : currentView.regionIndex;
            int n = fromPosition = currentView.needsNextRegion() ? 0 : currentView.toPosition;
        }
        if (regionIndex >= this.dirtyPages.size()) {
            return null;
        }
        FullPageId[] pageIds = (FullPageId[])this.dirtyPages.get((int)regionIndex).dirtyPages;
        FullPageId startPageId = pageIds[fromPosition];
        FullPageId endPageId = new FullPageId(PageIdUtils.pageId(PageIdUtils.partitionId(startPageId.pageId()) + 1, (byte)0, 0), startPageId.groupId());
        int toPosition = Arrays.binarySearch(pageIds, fromPosition, pageIds.length, endPageId, DIRTY_PAGE_COMPARATOR);
        toPosition = toPosition > 0 ? toPosition : -toPosition - 1;
        return new CheckpointDirtyPagesView(regionIndex, fromPosition, toPosition);
    }

    private static boolean equalsByGroupAndPartition(FullPageId pageId0, FullPageId pageId1) {
        return pageId0.groupId() == pageId1.groupId() && pageId0.partitionId() == pageId1.partitionId();
    }

    class CheckpointDirtyPagesView {
        private final int regionIndex;
        private final int fromPosition;
        private final int toPosition;

        private CheckpointDirtyPagesView(int regionIndex, int fromPosition, int toPosition) {
            this.regionIndex = regionIndex;
            this.fromPosition = fromPosition;
            this.toPosition = toPosition;
        }

        public FullPageId get(int index) {
            return ((FullPageId[])CheckpointDirtyPages.this.dirtyPages.get((int)this.regionIndex).dirtyPages)[this.fromPosition + index];
        }

        public PersistentPageMemory pageMemory() {
            return CheckpointDirtyPages.this.dirtyPages.get((int)this.regionIndex).pageMemory;
        }

        public int size() {
            return this.toPosition - this.fromPosition;
        }

        private CheckpointDirtyPages owner() {
            return CheckpointDirtyPages.this;
        }

        private boolean needsNextRegion() {
            return this.toPosition == ((FullPageId[])CheckpointDirtyPages.this.dirtyPages.get((int)this.regionIndex).dirtyPages).length;
        }
    }
}

