/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.causality.VersionedValue;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.manager.Producer;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.configuration.ExtendedTableConfiguration;
import org.apache.ignite.internal.schema.configuration.SchemaConfiguration;
import org.apache.ignite.internal.schema.configuration.SchemaView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.event.SchemaEvent;
import org.apache.ignite.internal.schema.event.SchemaEventParameters;
import org.apache.ignite.internal.schema.marshaller.schema.SchemaSerializerImpl;
import org.apache.ignite.internal.schema.registry.SchemaRegistryImpl;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteSystemProperties;
import org.apache.ignite.lang.IgniteTriConsumer;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaManager
extends Producer<SchemaEvent, SchemaEventParameters>
implements IgniteComponent {
    public static final int INITIAL_SCHEMA_VERSION = 1;
    private final boolean getMetadataLocallyOnly = IgniteSystemProperties.getBoolean((String)"IGNITE_GET_METADATA_LOCALLY_ONLY");
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final TablesConfiguration tablesCfg;
    private final VersionedValue<Map<UUID, SchemaRegistryImpl>> registriesVv;

    public SchemaManager(Consumer<Function<Long, CompletableFuture<?>>> registry, TablesConfiguration tablesCfg) {
        this.registriesVv = new VersionedValue(registry, HashMap::new);
        this.tablesCfg = tablesCfg;
    }

    public void start() {
        ((ExtendedTableConfiguration)this.tablesCfg.tables().any()).schemas().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<SchemaView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<SchemaView> schemasCtx) {
                return SchemaManager.this.onSchemaCreate(schemasCtx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> onSchemaCreate(ConfigurationNotificationEvent<SchemaView> schemasCtx) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            long causalityToken = schemasCtx.storageRevision();
            ExtendedTableConfiguration tblCfg = (ExtendedTableConfiguration)schemasCtx.config(ExtendedTableConfiguration.class);
            UUID tblId = (UUID)tblCfg.id().value();
            String tableName = (String)tblCfg.name().value();
            SchemaDescriptor schemaDescriptor = SchemaSerializerImpl.INSTANCE.deserialize(((SchemaView)schemasCtx.newValue()).schema());
            CompletableFuture<?> createSchemaFut = this.createSchema(causalityToken, tblId, tableName, schemaDescriptor);
            this.registriesVv.get(causalityToken).thenRun(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.fireEvent(SchemaEvent.CREATE, new SchemaEventParameters(causalityToken, tblId, schemaDescriptor))));
            CompletableFuture<?> completableFuture = createSchemaFut;
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> createSchema(long causalityToken, UUID tableId, String tableName, SchemaDescriptor schemaDescriptor) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<?> completableFuture = this.createSchemaInternal(causalityToken, tableId, tableName, schemaDescriptor);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<?> createSchemaInternal(long causalityToken, UUID tableId, String tableName, SchemaDescriptor schemaDescriptor) {
        return this.registriesVv.update(causalityToken, (registries, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (e != null) {
                return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(IgniteStringFormatter.format((String)"Cannot create a schema for the table [tblId={}, ver={}]", (Object[])new Object[]{tableId, schemaDescriptor.version()}), e));
            }
            HashMap<UUID, SchemaRegistryImpl> regs = registries;
            SchemaRegistryImpl reg = (SchemaRegistryImpl)regs.get(tableId);
            if (reg == null) {
                regs = new HashMap<UUID, SchemaRegistryImpl>((Map<UUID, SchemaRegistryImpl>)registries);
                SchemaRegistryImpl registry = this.createSchemaRegistry(tableId, tableName, schemaDescriptor);
                regs.put(tableId, registry);
            } else {
                reg.onSchemaRegistered(schemaDescriptor);
            }
            return CompletableFuture.completedFuture(regs);
        }));
    }

    private SchemaRegistryImpl createSchemaRegistry(UUID tableId, String tableName, SchemaDescriptor initialSchema) {
        return new SchemaRegistryImpl(ver -> {
            if (!this.busyLock.enterBusy()) {
                throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
            }
            try {
                SchemaDescriptor schemaDescriptor = this.tableSchema(tableId, tableName, (int)ver);
                return schemaDescriptor;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, () -> {
            if (!this.busyLock.enterBusy()) {
                throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
            }
            try {
                int n = this.latestSchemaVersion(tableId);
                return n;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }, initialSchema);
    }

    private SchemaDescriptor tableSchema(UUID tblId, String tableName, int schemaVer) {
        ExtendedTableConfiguration tblCfg = (ExtendedTableConfiguration)this.tablesCfg.tables().get(tableName);
        if (this.checkSchemaVersion(tblId, schemaVer)) {
            return this.getSchemaDescriptorLocally(schemaVer, tblCfg);
        }
        CompletableFuture fut = new CompletableFuture();
        IgniteTriConsumer schemaListener = (token, regs, e) -> {
            if (schemaVer <= ((SchemaRegistryImpl)regs.get(tblId)).lastSchemaVersion()) {
                fut.complete(this.getSchemaDescriptorLocally(schemaVer, tblCfg));
            }
        };
        this.registriesVv.whenComplete(schemaListener);
        if (this.checkSchemaVersion(tblId, schemaVer)) {
            this.registriesVv.removeWhenComplete(schemaListener);
            return this.getSchemaDescriptorLocally(schemaVer, tblCfg);
        }
        return (SchemaDescriptor)((CompletableFuture)fut.whenComplete((unused, throwable) -> this.registriesVv.removeWhenComplete(schemaListener))).join();
    }

    private boolean checkSchemaVersion(UUID tblId, int schemaVer) {
        SchemaRegistry registry = (SchemaRegistry)((Map)this.registriesVv.latest()).get(tblId);
        assert (registry != null) : IgniteStringFormatter.format((String)"Registry for the table not found [tblId={}]", (Object[])new Object[]{tblId});
        return schemaVer <= registry.lastSchemaVersion();
    }

    private boolean isSchemaExists(UUID tblId, int schemaVer) {
        return this.latestSchemaVersion(tblId) >= schemaVer;
    }

    private int latestSchemaVersion(UUID tblId) {
        try {
            NamedListView tblSchemas = (NamedListView)((ExtendedTableConfiguration)ConfigurationUtil.getByInternalId(this.directProxy((ConfigurationProperty)this.tablesCfg.tables()), (UUID)tblId)).schemas().value();
            int lastVer = 1;
            for (String schemaVerAsStr : tblSchemas.namedListKeys()) {
                int ver = Integer.parseInt(schemaVerAsStr);
                if (ver <= lastVer) continue;
                lastVer = ver;
            }
            return lastVer;
        }
        catch (NoSuchElementException e) {
            assert (false) : "Table must exist. [tableId=" + tblId + "]";
            return 1;
        }
    }

    @NotNull
    private SchemaDescriptor getSchemaDescriptorLocally(int schemaVer, ExtendedTableConfiguration tblCfg) {
        SchemaConfiguration schemaCfg = (SchemaConfiguration)tblCfg.schemas().get(String.valueOf(schemaVer));
        assert (schemaCfg != null);
        return SchemaSerializerImpl.INSTANCE.deserialize((byte[])schemaCfg.schema().value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SchemaRegistry> schemaRegistry(long causalityToken, @Nullable UUID tableId) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.registriesVv.get(causalityToken).thenApply(regs -> (SchemaRegistry)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> tableId == null ? null : (SchemaRegistryImpl)regs.get(tableId)));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public SchemaRegistry schemaRegistry(UUID tableId) {
        return (SchemaRegistry)((Map)this.registriesVv.latest()).get(tableId);
    }

    public CompletableFuture<?> dropRegistry(long causalityToken, UUID tableId) {
        return this.registriesVv.update(causalityToken, (registries, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (e != null) {
                return CompletableFuture.failedFuture((Throwable)new IgniteInternalException(IgniteStringFormatter.format((String)"Cannot remove a schema registry for the table [tblId={}]", (Object[])new Object[]{tableId}), e));
            }
            HashMap regs = new HashMap(registries);
            regs.remove(tableId);
            return CompletableFuture.completedFuture(regs);
        }));
    }

    public void stop() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
    }

    private <T extends ConfigurationProperty<?>> T directProxy(T property) {
        return (T)(this.getMetadataLocallyOnly ? property : ConfigurationUtil.directProxy(property));
    }
}

