/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.registry;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaException;
import org.apache.ignite.internal.schema.mapping.ColumnMapper;
import org.apache.ignite.internal.schema.row.Row;
import org.jetbrains.annotations.NotNull;

class UpgradingRowAdapter
extends Row {
    private final ColumnMapper mapper;
    private final SchemaDescriptor schema;

    UpgradingRowAdapter(SchemaDescriptor schema, SchemaDescriptor rowSchema, BinaryRow row, ColumnMapper mapper) {
        super(rowSchema, row);
        this.schema = schema;
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    private int mapColumn(int colIdx) throws InvalidTypeException {
        return this.mapper.map(colIdx);
    }

    @Override
    public Object value(int colIdx) {
        int mappedId = this.mapColumn(colIdx);
        return mappedId < 0 ? this.mapper.mappedColumn(colIdx).defaultValue() : this.schema.column(colIdx).type().spec().objectValue(this, colIdx);
    }

    @Override
    public byte byteValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT8 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Byte)column.defaultValue()).byteValue() : super.byteValue(mappedId);
    }

    @Override
    public Byte byteValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT8 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Byte)column.defaultValue() : super.byteValueBoxed(mappedId);
    }

    @Override
    public short shortValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT16 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Short)column.defaultValue()).shortValue() : super.shortValue(mappedId);
    }

    @Override
    public Short shortValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT16 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Short)column.defaultValue() : super.shortValueBoxed(mappedId);
    }

    @Override
    public int intValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT32 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Integer)column.defaultValue()).intValue() : super.intValue(mappedId);
    }

    @Override
    public Integer intValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT32 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Integer)column.defaultValue() : super.intValueBoxed(mappedId);
    }

    @Override
    public long longValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT64 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Long)column.defaultValue()).longValue() : super.longValue(mappedId);
    }

    @Override
    public Long longValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.INT64 != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Long)column.defaultValue() : super.longValueBoxed(mappedId);
    }

    @Override
    public float floatValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.FLOAT != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Float)column.defaultValue()).floatValue() : super.floatValue(mappedId);
    }

    @Override
    public Float floatValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.FLOAT != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Float)column.defaultValue() : super.floatValueBoxed(mappedId);
    }

    @Override
    public double doubleValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.DOUBLE != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? ((Double)column.defaultValue()).doubleValue() : super.doubleValue(mappedId);
    }

    @Override
    public Double doubleValueBoxed(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.DOUBLE != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Double)column.defaultValue() : super.doubleValueBoxed(mappedId);
    }

    @Override
    public BigDecimal decimalValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.DECIMAL != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (BigDecimal)column.defaultValue() : super.decimalValue(mappedId);
    }

    @Override
    public BigInteger numberValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.NUMBER != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (BigInteger)column.defaultValue() : super.numberValue(mappedId);
    }

    @Override
    public String stringValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.STRING != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (String)column.defaultValue() : super.stringValue(mappedId);
    }

    @Override
    public byte[] bytesValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.BYTES != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (byte[])column.defaultValue() : super.bytesValue(mappedId);
    }

    @Override
    public UUID uuidValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.UUID != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (UUID)column.defaultValue() : super.uuidValue(mappedId);
    }

    @Override
    public BitSet bitmaskValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.BITMASK != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (BitSet)column.defaultValue() : super.bitmaskValue(mappedId);
    }

    @Override
    public LocalDate dateValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.DATE != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalDate)column.defaultValue() : super.dateValue(mappedId);
    }

    @Override
    public LocalTime timeValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.TIME != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalTime)column.defaultValue() : super.timeValue(mappedId);
    }

    @Override
    public LocalDateTime dateTimeValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.DATETIME != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (LocalDateTime)column.defaultValue() : super.dateTimeValue(mappedId);
    }

    @Override
    public Instant timestampValue(int colIdx) throws InvalidTypeException {
        Column column;
        int mappedId = this.mapColumn(colIdx);
        Column column2 = column = mappedId < 0 ? this.mapper.mappedColumn(colIdx) : super.schema().column(mappedId);
        if (NativeTypeSpec.TIMESTAMP != column.type().spec()) {
            throw new SchemaException("Type conversion is not supported yet.");
        }
        return mappedId < 0 ? (Instant)column.defaultValue() : super.timestampValue(mappedId);
    }
}

