/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.Collection;
import java.util.Set;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class TableFunctionScanConverterRule
extends AbstractIgniteConverterRule<LogicalTableFunctionScan> {
    public static final RelOptRule INSTANCE = new TableFunctionScanConverterRule();

    private TableFunctionScanConverterRule() {
        super(LogicalTableFunctionScan.class, "TableFunctionScanConverterRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalTableFunctionScan rel) {
        assert (CollectionUtils.nullOrEmpty((Collection)rel.getInputs()));
        RelTraitSet traitSet = rel.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)IgniteDistributions.broadcast());
        Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.getCall());
        if (!corrIds.isEmpty()) {
            traitSet = traitSet.replace((RelTrait)CorrelationTrait.correlations(corrIds));
        }
        return new IgniteTableFunctionScan(rel.getCluster(), traitSet, rel.getCall(), rel.getRowType());
    }
}

