/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import org.apache.calcite.plan.RelMultipleTrait;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTraitDef;
import org.jetbrains.annotations.NotNull;

public class RewindabilityTrait
implements RelMultipleTrait {
    public static final RewindabilityTrait ONE_WAY = RewindabilityTrait.canonize(new RewindabilityTrait(false));
    public static final RewindabilityTrait REWINDABLE = RewindabilityTrait.canonize(new RewindabilityTrait(true));
    private final boolean rewindable;

    private RewindabilityTrait(boolean rewindable) {
        this.rewindable = rewindable;
    }

    public boolean rewindable() {
        return this.rewindable;
    }

    public boolean isTop() {
        return !this.rewindable();
    }

    public int compareTo(@NotNull RelMultipleTrait o) {
        RewindabilityTrait that = (RewindabilityTrait)o;
        return Boolean.compare(that.rewindable, this.rewindable);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RewindabilityTrait)) {
            return false;
        }
        return this.compareTo((RelMultipleTrait)o) == 0;
    }

    public int hashCode() {
        return this.rewindable ? 1 : 0;
    }

    public String toString() {
        return this.rewindable ? "rewindable" : "one-way";
    }

    public RelTraitDef<RewindabilityTrait> getTraitDef() {
        return RewindabilityTraitDef.INSTANCE;
    }

    public boolean satisfies(RelTrait trait) {
        if (this == trait) {
            return true;
        }
        if (!(trait instanceof RewindabilityTrait)) {
            return false;
        }
        RewindabilityTrait trait0 = (RewindabilityTrait)trait;
        return !trait0.rewindable() || this.rewindable();
    }

    public void register(RelOptPlanner planner) {
    }

    private static RewindabilityTrait canonize(RewindabilityTrait trait) {
        return (RewindabilityTrait)RewindabilityTraitDef.INSTANCE.canonize((RelTrait)trait);
    }
}

