/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.monitor;

import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.Member;
import io.scalecube.net.Address;
import java.util.List;
import java.util.function.Supplier;

public class ClusterMonitorModel {
    private final Cluster cluster;
    private final ClusterConfig config;
    private final Supplier<Integer> incarnationSupplier;
    private final List<Address> seedMembers;
    private final Supplier<List<Member>> aliveMembersSupplier;
    private final Supplier<List<Member>> suspectedMembersSupplier;
    private final Supplier<List<Member>> removedMembersSupplier;

    private ClusterMonitorModel(Builder builder) {
        this.cluster = builder.cluster;
        this.config = builder.config;
        this.incarnationSupplier = builder.incarnationSupplier;
        this.seedMembers = builder.seedMembers;
        this.aliveMembersSupplier = builder.aliveMembersSupplier;
        this.suspectedMembersSupplier = builder.suspectedMembersSupplier;
        this.removedMembersSupplier = builder.removedMembersSupplier;
    }

    public ClusterConfig config() {
        return this.config;
    }

    public int incarnation() {
        return this.incarnationSupplier.get();
    }

    public int clusterSize() {
        return this.cluster.otherMembers().size() + 1;
    }

    public Member member() {
        return this.cluster.member();
    }

    public Object metadata() {
        return this.cluster.metadata().orElse(null);
    }

    public List<Address> seedMembers() {
        return this.seedMembers;
    }

    public List<Member> aliveMembers() {
        return this.aliveMembersSupplier.get();
    }

    public List<Member> suspectedMembers() {
        return this.suspectedMembersSupplier.get();
    }

    public List<Member> removedMembers() {
        return this.removedMembersSupplier.get();
    }

    public static class Builder {
        private Cluster cluster;
        private ClusterConfig config;
        private Supplier<Integer> incarnationSupplier;
        private List<Address> seedMembers;
        private Supplier<List<Member>> aliveMembersSupplier;
        private Supplier<List<Member>> suspectedMembersSupplier;
        private Supplier<List<Member>> removedMembersSupplier;

        public ClusterMonitorModel build() {
            return new ClusterMonitorModel(this);
        }

        public Builder config(ClusterConfig config) {
            this.config = config;
            return this;
        }

        public Builder cluster(Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder incarnationSupplier(Supplier<Integer> incarnationSupplier) {
            this.incarnationSupplier = incarnationSupplier;
            return this;
        }

        public Builder seedMembers(List<Address> seedMembers) {
            this.seedMembers = seedMembers;
            return this;
        }

        public Builder aliveMembersSupplier(Supplier<List<Member>> aliveMembersSupplier) {
            this.aliveMembersSupplier = aliveMembersSupplier;
            return this;
        }

        public Builder suspectedMembersSupplier(Supplier<List<Member>> suspectedMembersSupplier) {
            this.suspectedMembersSupplier = suspectedMembersSupplier;
            return this;
        }

        public Builder removedMembersSupplier(Supplier<List<Member>> removedMembersSupplier) {
            this.removedMembersSupplier = removedMembersSupplier;
            return this;
        }
    }
}

