/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.util.Locale;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbDataRegionConfiguration;
import org.apache.ignite.internal.storage.rocksdb.configuration.schema.RocksDbDataRegionView;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.Cache;
import org.rocksdb.ClockCache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;

public class RocksDbDataRegion {
    private final RocksDbDataRegionConfiguration cfg;
    private Cache cache;
    private WriteBufferManager writeBufferManager;

    public RocksDbDataRegion(RocksDbDataRegionConfiguration cfg) {
        this.cfg = cfg;
    }

    public void start() {
        RocksDbDataRegionView dataRegionView = (RocksDbDataRegionView)this.cfg.value();
        long writeBufferSize = dataRegionView.writeBufferSize();
        long totalCacheSize = dataRegionView.size() + writeBufferSize;
        switch (dataRegionView.cache().toLowerCase(Locale.ROOT)) {
            case "clock": {
                this.cache = new ClockCache(totalCacheSize, dataRegionView.numShardBits(), false);
                break;
            }
            case "lru": {
                this.cache = new LRUCache(totalCacheSize, dataRegionView.numShardBits(), false);
                break;
            }
            default: {
                assert (false) : dataRegionView.cache();
                break;
            }
        }
        this.writeBufferManager = new WriteBufferManager(writeBufferSize, this.cache);
    }

    public void stop() throws Exception {
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.writeBufferManager, this.cache});
    }

    public WriteBufferManager writeBufferManager() {
        return this.writeBufferManager;
    }
}

