/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.tx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.ignite.shaded.org.apache.ignite.tx.IgniteTransactions;
import org.apache.ignite.shaded.org.apache.ignite.tx.RetriableTransactionException;
import org.apache.ignite.shaded.org.apache.ignite.tx.Transaction;
import org.apache.ignite.shaded.org.apache.ignite.tx.TransactionException;
import org.apache.ignite.shaded.org.apache.ignite.tx.TransactionOptions;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

class RunInTransactionInternalImpl {
    private static final int MAX_SUPPRESSED = 100;

    RunInTransactionInternalImpl() {
    }

    static <T> T runInTransactionInternal(IgniteTransactions igniteTransactions, Function<Transaction, T> clo, @Nullable TransactionOptions options, long startTimestamp, long initialTimeout) throws TransactionException {
        T ret;
        Transaction tx;
        Objects.requireNonNull(clo);
        TransactionOptions txOptions = options == null ? new TransactionOptions().timeoutMillis(TimeUnit.SECONDS.toMillis(30L)) : options;
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        while (true) {
            tx = igniteTransactions.begin(txOptions);
            try {
                ret = clo.apply(tx);
            }
            catch (Exception ex) {
                RunInTransactionInternalImpl.addSuppressedToList(suppressed, ex);
                long remainingTime = RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp);
                if (remainingTime > 0L && RunInTransactionInternalImpl.isRetriable(ex)) {
                    RunInTransactionInternalImpl.rollbackWithRetry(tx, ex, startTimestamp, initialTimeout, suppressed);
                    long remaining = RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp);
                    if (remaining > 0L) {
                        txOptions = txOptions.timeoutMillis(remainingTime);
                        continue;
                    }
                    RunInTransactionInternalImpl.throwExceptionWithSuppressed(ex, suppressed);
                    continue;
                }
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    RunInTransactionInternalImpl.addSuppressedToList(suppressed, e);
                }
                RunInTransactionInternalImpl.throwExceptionWithSuppressed(ex, suppressed);
                continue;
            }
            break;
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception re) {
                e.addSuppressed(re);
            }
            throw e;
        }
        return ret;
    }

    private static void rollbackWithRetry(Transaction tx, Exception closureException, long startTimestamp, long initialTimeout, List<Throwable> suppressed) {
        while (true) {
            try {
                tx.rollback();
            }
            catch (Exception re) {
                RunInTransactionInternalImpl.addSuppressedToList(suppressed, re);
                if (RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp) > 0L) continue;
                RunInTransactionInternalImpl.throwExceptionWithSuppressed(closureException, suppressed);
                continue;
            }
            break;
        }
    }

    static <T> CompletableFuture<T> runInTransactionAsyncInternal(IgniteTransactions igniteTransactions, Function<Transaction, CompletableFuture<T>> clo, @Nullable TransactionOptions options, long startTimestamp, long initialTimeout, @Nullable List<Throwable> suppressed) {
        Objects.requireNonNull(clo);
        TransactionOptions txOptions = options == null ? new TransactionOptions().timeoutMillis(TimeUnit.SECONDS.toMillis(30L)) : options;
        List<Throwable> sup = suppressed == null ? Collections.synchronizedList(new ArrayList()) : suppressed;
        return ((CompletableFuture)igniteTransactions.beginAsync(txOptions).thenCompose(tx -> {
            try {
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)clo.apply((Transaction)tx)).handle((res, e) -> {
                    if (e != null) {
                        return RunInTransactionInternalImpl.handleClosureException(igniteTransactions, tx, clo, txOptions, startTimestamp, initialTimeout, sup, e);
                    }
                    return CompletableFuture.completedFuture(res);
                })).thenCompose(Function.identity())).thenApply(res -> new TxWithVal<Object>((Transaction)tx, res));
            }
            catch (Exception e2) {
                return RunInTransactionInternalImpl.handleClosureException(igniteTransactions, tx, clo, txOptions, startTimestamp, initialTimeout, sup, e2).thenApply(res -> new TxWithVal<Object>((Transaction)tx, res));
            }
        })).thenCompose(txWithVal -> ((CompletableFuture)((CompletableFuture)txWithVal.tx.commitAsync().handle((ignored, e) -> {
            if (e == null) {
                return CompletableFuture.completedFuture(null);
            }
            return txWithVal.tx.rollbackAsync().handle((ign, re) -> RunInTransactionInternalImpl.sneakyThrow(e));
        })).thenCompose(fut -> fut)).thenApply(ignored -> txWithVal.val));
    }

    private static <T> CompletableFuture<T> handleClosureException(IgniteTransactions igniteTransactions, Transaction currentTx, Function<Transaction, CompletableFuture<T>> clo, TransactionOptions txOptions, long startTimestamp, long initialTimeout, List<Throwable> suppressed, Throwable e) {
        RunInTransactionInternalImpl.addSuppressedToList(suppressed, e);
        long remainingTime = RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp);
        if (remainingTime > 0L && RunInTransactionInternalImpl.isRetriable(e)) {
            return RunInTransactionInternalImpl.rollbackWithRetryAsync(currentTx, startTimestamp, initialTimeout, suppressed, e).thenCompose(ignored -> {
                long remaining = RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp);
                if (remaining > 0L) {
                    TransactionOptions opt = txOptions.timeoutMillis(remaining);
                    return RunInTransactionInternalImpl.runInTransactionAsyncInternal(igniteTransactions, clo, opt, startTimestamp, initialTimeout, suppressed);
                }
                return RunInTransactionInternalImpl.throwExceptionWithSuppressedAsync(e, suppressed).thenApply(ign -> null);
            });
        }
        return ((CompletableFuture)((CompletableFuture)currentTx.rollbackAsync().exceptionally(re -> {
            RunInTransactionInternalImpl.addSuppressedToList(suppressed, re);
            return null;
        })).thenCompose(ignored -> RunInTransactionInternalImpl.throwExceptionWithSuppressedAsync(e, suppressed))).thenApply(ignored -> null);
    }

    private static CompletableFuture<Void> rollbackWithRetryAsync(Transaction tx, long startTimestamp, long initialTimeout, List<Throwable> suppressed, Throwable e) {
        return ((CompletableFuture)tx.rollbackAsync().handle((ignored, re) -> {
            CompletableFuture<Object> fut;
            if (re == null) {
                fut = CompletableFuture.completedFuture(null);
            } else {
                RunInTransactionInternalImpl.addSuppressedToList(suppressed, re);
                if (RunInTransactionInternalImpl.calcRemainingTime(initialTimeout, startTimestamp) <= 0L) {
                    for (Throwable s : suppressed) {
                        RunInTransactionInternalImpl.addSuppressed(e, s);
                    }
                    fut = CompletableFuture.failedFuture(e);
                } else {
                    fut = RunInTransactionInternalImpl.rollbackWithRetryAsync(tx, startTimestamp, initialTimeout, suppressed, e);
                }
            }
            return fut;
        })).thenCompose(Function.identity());
    }

    private static void addSuppressedToList(List<Throwable> to, Throwable a) {
        if (to.size() < 100) {
            to.add(a);
        }
    }

    private static void addSuppressed(Throwable to, Throwable a) {
        if (to != null && a != null && to != a && to.getSuppressed().length < 100) {
            to.addSuppressed(a);
        }
    }

    private static void throwExceptionWithSuppressed(Throwable e, List<Throwable> suppressed) {
        for (Throwable t : suppressed) {
            RunInTransactionInternalImpl.addSuppressed(e, t);
        }
        RunInTransactionInternalImpl.sneakyThrow(e);
    }

    private static CompletableFuture<Void> throwExceptionWithSuppressedAsync(Throwable e, List<Throwable> suppressed) {
        for (Throwable t : suppressed) {
            RunInTransactionInternalImpl.addSuppressed(e, t);
        }
        return CompletableFuture.failedFuture(e);
    }

    private static boolean isRetriable(Throwable e) {
        return RunInTransactionInternalImpl.hasCause(e, TimeoutException.class, RetriableTransactionException.class);
    }

    private static boolean hasCause(Throwable e, Class<?> ... classes) {
        HashSet<Throwable> processed = new HashSet<Throwable>();
        for (Throwable cause = e; cause != null && processed.add(cause); cause = cause.getCause()) {
            for (Class<?> cls : classes) {
                if (!cls.isAssignableFrom(cause.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    private static long calcRemainingTime(long initialTimeout, long startTimestamp) {
        long now = System.currentTimeMillis();
        long remainingTime = initialTimeout - (now - startTimestamp);
        return remainingTime;
    }

    private static <E extends Throwable> E sneakyThrow(Throwable e) throws E {
        throw e;
    }

    private static class TxWithVal<T> {
        private final Transaction tx;
        private final T val;

        private TxWithVal(Transaction tx, T val) {
            this.tx = tx;
            this.val = val;
        }
    }
}

