/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.tx;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

class ScriptTransactionWrapperImpl
implements QueryTransactionWrapper {
    private final InternalTransaction managedTx;
    private final CompletableFuture<Void> txFinishFuture = new CompletableFuture();
    private final Map<UUID, CompletableFuture<? extends AsyncDataCursor<?>>> openedCursors = new HashMap();
    private final Object mux = new Object();
    private volatile State txState;
    private Throwable rollbackCause;
    private final TransactionalOperationTracker txTracker;
    private final AtomicBoolean completedTx = new AtomicBoolean();

    ScriptTransactionWrapperImpl(InternalTransaction managedTx, TransactionalOperationTracker txTracker) {
        this.managedTx = managedTx;
        this.txTracker = txTracker;
    }

    @Override
    public InternalTransaction unwrap() {
        return this.managedTx;
    }

    @Override
    public CompletableFuture<Void> finalise() {
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> finalise(Throwable error) {
        assert (error != null);
        Object object = this.mux;
        synchronized (object) {
            if (this.rollbackCause != null) {
                return this.txFinishFuture;
            }
            this.rollbackCause = error;
            this.txState = State.ROLLBACK;
        }
        this.completeTx();
        return this.txFinishFuture;
    }

    @Override
    public boolean implicit() {
        return false;
    }

    CompletableFuture<Void> commit() {
        this.changeState(State.COMMIT);
        return this.txFinishFuture.handle((ignore, ex) -> {
            Object object = this.mux;
            synchronized (object) {
                if (this.rollbackCause == null && ex == null) {
                    return ignore;
                }
                if (this.rollbackCause != null) {
                    if (ex != null) {
                        this.rollbackCause.addSuppressed((Throwable)ex);
                    }
                    throw new CompletionException(this.rollbackCause);
                }
                throw new CompletionException((Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerCursorFuture(CompletableFuture<AsyncSqlCursor<InternalSqlRow>> cursorFut) {
        UUID cursorId = UUID.randomUUID();
        Object object = this.mux;
        synchronized (object) {
            if (this.txState != null) {
                assert (this.txState == State.ROLLBACK);
                throw new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, "The transaction has already been rolled back due to an error in the previous statement.", this.rollbackCause);
            }
            this.openedCursors.put(cursorId, cursorFut);
        }
        cursorFut.whenComplete((cur, ex) -> {
            if (cur != null) {
                cur.onClose().whenComplete((none, ignored) -> {
                    Object object = this.mux;
                    synchronized (object) {
                        if (this.openedCursors.remove(cursorId) == null || this.txState == null || !this.openedCursors.isEmpty()) {
                            return;
                        }
                    }
                    this.completeTx();
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State newState) {
        Object object = this.mux;
        synchronized (object) {
            if (this.txState != null) {
                return;
            }
            this.txState = newState;
            if (!this.openedCursors.isEmpty()) {
                return;
            }
        }
        this.completeTx();
    }

    private void completeTx() {
        switch (this.txState.ordinal()) {
            case 0: {
                this.managedTx.commitAsync().whenComplete(this::completeTxFuture);
                break;
            }
            case 1: {
                this.managedTx.rollbackAsync().whenComplete(this::completeTxFuture);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transaction target state: " + String.valueOf((Object)this.txState));
            }
        }
        if (this.completedTx.compareAndSet(false, true)) {
            this.txTracker.registerOperationFinish(this.managedTx);
        }
    }

    private void completeTxFuture(@Nullable Void unused, Throwable e) {
        if (e != null) {
            this.txFinishFuture.completeExceptionally(e);
        } else {
            this.txFinishFuture.complete(null);
        }
    }

    private static enum State {
        COMMIT,
        ROLLBACK;

    }
}

