/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.util.NodeValue;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    @Nullable
    public static <T> T convert(TraversableTreeNode root, List<String> path, ConfigurationVisitor<T> visitor) throws IllegalArgumentException {
        NodeValue node;
        try {
            node = ConfigurationUtil.find(path, root, false);
        }
        catch (KeyNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Object value = node.value();
        if (value instanceof TraversableTreeNode) {
            return ((TraversableTreeNode)value).accept(node.field(), null, visitor);
        }
        assert (value == null || value instanceof Serializable);
        return visitor.visitLeafNode(node.field(), null, (Serializable)value);
    }
}

