/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Reset zone partitions configuration.")
public class ResetZonePartitionsRequest {
    @Schema(description="Name of the zone to reset partitions of. Without quotes, case-sensitive.")
    private final String zoneName;
    @Schema(description="IDs of partitions to reset. All if empty.")
    private final Set<Integer> partitionIds;

    @JsonCreator
    public ResetZonePartitionsRequest(@JsonProperty(value="zoneName") String zoneName, @JsonProperty(value="partitionIds") @Nullable Collection<Integer> partitionIds) {
        Objects.requireNonNull(zoneName);
        this.zoneName = zoneName;
        this.partitionIds = partitionIds == null ? Set.of() : Set.copyOf(partitionIds);
    }

    @JsonGetter(value="partitionIds")
    public Set<Integer> partitionIds() {
        return this.partitionIds;
    }

    @JsonGetter(value="zoneName")
    public String zoneName() {
        return this.zoneName;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

