/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.metrics;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.metric.Metric;
import org.apache.ignite.internal.rest.api.metric.MetricSet;
import org.apache.ignite.internal.rest.api.metric.MetricSource;
import org.apache.ignite.internal.rest.api.metric.NodeMetricApi;
import org.apache.ignite.internal.rest.metrics.exception.MetricNotFoundException;

@Controller(value="/management/v1/metric/node")
public class NodeMetricController
implements NodeMetricApi,
ResourceHolder {
    private MetricManager metricManager;

    public NodeMetricController(MetricManager metricManager) {
        this.metricManager = metricManager;
    }

    public void enable(String srcName) {
        try {
            this.metricManager.enable(srcName);
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    public void disable(String srcName) {
        try {
            this.metricManager.disable(srcName);
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    public Collection<MetricSource> listMetricSources() {
        return this.metricManager.metricSources().stream().map(source -> new MetricSource(source.name(), source.enabled())).sorted(Comparator.comparing(MetricSource::name)).collect(Collectors.toList());
    }

    public Collection<MetricSet> listMetricSets() {
        return this.metricManager.metricSnapshot().metrics().values().stream().map(metricSet -> {
            List metricDtos = StreamSupport.stream(metricSet.spliterator(), false).map(metric -> new Metric(metric.name(), metric.description())).sorted(Comparator.comparing(Metric::name)).collect(Collectors.toList());
            return new MetricSet(metricSet.name(), metricDtos);
        }).sorted(Comparator.comparing(MetricSet::name)).collect(Collectors.toList());
    }

    public void cleanResources() {
        this.metricManager = null;
    }
}

