/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommand;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommandBuilder;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaChangeCommandSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class PrimaryReplicaChangeCommandImpl
implements PrimaryReplicaChangeCommand,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 41;
    @IgniteToStringInclude
    private final long leaseStartTime;
    @IgniteToStringInclude
    private final UUID primaryReplicaNodeId;
    @IgniteToStringInclude
    private final String primaryReplicaNodeName;

    private PrimaryReplicaChangeCommandImpl(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        this.leaseStartTime = leaseStartTime;
        this.primaryReplicaNodeId = primaryReplicaNodeId;
        this.primaryReplicaNodeName = primaryReplicaNodeName;
    }

    @Override
    public long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public UUID primaryReplicaNodeId() {
        return this.primaryReplicaNodeId;
    }

    @Override
    public String primaryReplicaNodeName() {
        return this.primaryReplicaNodeName;
    }

    public MessageSerializer serializer() {
        return PrimaryReplicaChangeCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(PrimaryReplicaChangeCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 41;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PrimaryReplicaChangeCommandImpl otherMessage = (PrimaryReplicaChangeCommandImpl)other;
        return Objects.equals(this.primaryReplicaNodeId, otherMessage.primaryReplicaNodeId) && Objects.equals(this.primaryReplicaNodeName, otherMessage.primaryReplicaNodeName) && this.leaseStartTime == otherMessage.leaseStartTime;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.leaseStartTime, this.primaryReplicaNodeId, this.primaryReplicaNodeName);
        return result;
    }

    public PrimaryReplicaChangeCommandImpl clone() {
        try {
            return (PrimaryReplicaChangeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PrimaryReplicaChangeCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PrimaryReplicaChangeCommandBuilder {
        private long leaseStartTime;
        private UUID primaryReplicaNodeId;
        private String primaryReplicaNodeName;

        private Builder() {
        }

        @Override
        public PrimaryReplicaChangeCommandBuilder leaseStartTime(long leaseStartTime) {
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public PrimaryReplicaChangeCommandBuilder primaryReplicaNodeId(UUID primaryReplicaNodeId) {
            Objects.requireNonNull(primaryReplicaNodeId, "primaryReplicaNodeId is not marked @Nullable");
            this.primaryReplicaNodeId = primaryReplicaNodeId;
            return this;
        }

        @Override
        public PrimaryReplicaChangeCommandBuilder primaryReplicaNodeName(String primaryReplicaNodeName) {
            Objects.requireNonNull(primaryReplicaNodeName, "primaryReplicaNodeName is not marked @Nullable");
            this.primaryReplicaNodeName = primaryReplicaNodeName;
            return this;
        }

        @Override
        public long leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public UUID primaryReplicaNodeId() {
            return this.primaryReplicaNodeId;
        }

        @Override
        public String primaryReplicaNodeName() {
            return this.primaryReplicaNodeName;
        }

        @Override
        public PrimaryReplicaChangeCommand build() {
            return new PrimaryReplicaChangeCommandImpl(this.leaseStartTime, Objects.requireNonNull(this.primaryReplicaNodeId, "primaryReplicaNodeId is not marked @Nullable"), Objects.requireNonNull(this.primaryReplicaNodeName, "primaryReplicaNodeName is not marked @Nullable"));
        }
    }
}

