/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsColumnData;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsDecimalMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsObjectData;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class StatisticsUtils {
    public static StatisticsColumnData toMessage(ColumnStatistics stat) throws IgniteCheckedException {
        StatisticsDecimalMessage msgMin = new StatisticsDecimalMessage(stat.min());
        StatisticsDecimalMessage msgMax = new StatisticsDecimalMessage(stat.max());
        return new StatisticsColumnData(msgMin, msgMax, stat.nulls(), stat.distinct(), stat.total(), stat.size(), stat.raw(), stat.version(), stat.createdAt());
    }

    public static ColumnStatistics toColumnStatistics(GridKernalContext ctx, StatisticsColumnData data) {
        return new ColumnStatistics(data.min().value(), data.max().value(), data.nulls(), data.distinct(), data.total(), data.size(), data.rawData(), data.version(), data.createdAt());
    }

    public static StatisticsObjectData toObjectData(StatisticsKeyMessage keyMsg, StatisticsType type, ObjectStatisticsImpl stat) throws IgniteCheckedException {
        StatisticsObjectData data;
        HashMap<String, StatisticsColumnData> colData = new HashMap<String, StatisticsColumnData>(stat.columnsStatistics().size());
        for (Map.Entry<String, ColumnStatistics> ts : stat.columnsStatistics().entrySet()) {
            colData.put(ts.getKey(), StatisticsUtils.toMessage(ts.getValue()));
        }
        if (stat instanceof ObjectPartitionStatisticsImpl) {
            ObjectPartitionStatisticsImpl partStats = (ObjectPartitionStatisticsImpl)stat;
            data = new StatisticsObjectData(keyMsg, stat.rowCount(), type, partStats.partId(), partStats.updCnt(), colData);
        } else {
            data = new StatisticsObjectData(keyMsg, stat.rowCount(), type, 0, 0L, colData);
        }
        return data;
    }

    public static StatisticsKeyMessage toMessage(String schema, String obj, String ... colNames) {
        return new StatisticsKeyMessage(schema, obj, F.asList(colNames));
    }

    public static ObjectPartitionStatisticsImpl toObjectPartitionStatistics(GridKernalContext ctx, StatisticsObjectData objData) throws IgniteCheckedException {
        if (objData == null) {
            return null;
        }
        assert (objData.type() == StatisticsType.PARTITION);
        HashMap<String, ColumnStatistics> colNameToStat = new HashMap<String, ColumnStatistics>(objData.data().size());
        for (Map.Entry<String, StatisticsColumnData> cs : objData.data().entrySet()) {
            colNameToStat.put(cs.getKey(), StatisticsUtils.toColumnStatistics(ctx, cs.getValue()));
        }
        return new ObjectPartitionStatisticsImpl(objData.partId(), objData.rowsCnt(), objData.updCnt(), colNameToStat);
    }

    public static ObjectStatisticsImpl toObjectStatistics(GridKernalContext ctx, StatisticsObjectData data) {
        HashMap<String, ColumnStatistics> colNameToStat = new HashMap<String, ColumnStatistics>(data.data().size());
        for (Map.Entry<String, StatisticsColumnData> cs : data.data().entrySet()) {
            colNameToStat.put(cs.getKey(), StatisticsUtils.toColumnStatistics(ctx, cs.getValue()));
        }
        return new ObjectStatisticsImpl(data.rowsCnt(), colNameToStat);
    }

    public static StatisticsTarget statisticsTarget(StatisticsKeyMessage msg) {
        String[] cols = msg.colNames() == null ? null : msg.colNames().toArray(new String[0]);
        return new StatisticsTarget(msg.schema(), msg.obj(), cols);
    }

    public static int compareVersions(ObjectStatisticsImpl stat, Map<String, Long> versions) {
        if (stat == null) {
            return -1;
        }
        for (Map.Entry<String, Long> ver : versions.entrySet()) {
            ColumnStatistics colStat = stat.columnsStatistics().get(ver.getKey());
            if (colStat == null || colStat.version() < ver.getValue()) {
                return -1;
            }
            if (colStat.version() <= ver.getValue()) continue;
            return 1;
        }
        return 0;
    }

    public static int compareVersions(StatisticsObjectConfiguration cfg, Map<String, Long> versions) {
        if (cfg == null) {
            return -1;
        }
        for (Map.Entry<String, Long> colVer : versions.entrySet()) {
            StatisticsColumnConfiguration colCfg = cfg.columns().get(colVer.getKey());
            if (colCfg == null || colCfg.version() < colVer.getValue()) {
                return -1;
            }
            if (colCfg.version() <= colVer.getValue()) continue;
            return 1;
        }
        return 0;
    }

    public static BigDecimal toDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = U.box(obj.getClass());
        if (Boolean.class.isAssignableFrom(cls)) {
            return (Boolean)obj != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (Byte.class.isAssignableFrom(cls)) {
            return BigDecimal.valueOf(((Byte)obj).byteValue());
        }
        if (Short.class.isAssignableFrom(cls)) {
            return BigDecimal.valueOf(((Short)obj).shortValue());
        }
        if (Integer.class.isAssignableFrom(cls)) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
        if (Long.class.isAssignableFrom(cls)) {
            return new BigDecimal((Long)obj);
        }
        if (Float.class.isAssignableFrom(cls)) {
            return BigDecimal.valueOf(((Float)obj).floatValue());
        }
        if (Double.class.isAssignableFrom(cls)) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (BigDecimal.class.isAssignableFrom(cls)) {
            return (BigDecimal)obj;
        }
        if (UUID.class.isAssignableFrom(cls)) {
            BigInteger bigInt = new BigInteger(1, U.uuidToBytes((UUID)obj));
            return new BigDecimal(bigInt);
        }
        if (Date.class.isAssignableFrom(cls)) {
            return new BigDecimal(((Date)obj).getTime());
        }
        if (LocalDate.class.isAssignableFrom(cls)) {
            return new BigDecimal(DateValueUtils.convertToSqlDate((LocalDate)obj).getTime());
        }
        if (LocalTime.class.isAssignableFrom(cls)) {
            return new BigDecimal(DateValueUtils.convertToSqlTime((LocalTime)obj).getTime());
        }
        if (LocalDateTime.class.isAssignableFrom(cls)) {
            return new BigDecimal(DateValueUtils.convertToTimestamp((LocalDateTime)obj).getTime());
        }
        throw new IllegalArgumentException("Value of type " + cls.getName() + " is not expected");
    }
}

