/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.cluster;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.ClusterManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.InitCommand;

@Singleton
public class ClusterInitCall
implements Call<ClusterInitCallInput, String> {
    private final ApiClientFactory clientFactory;

    public ClusterInitCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(ClusterInitCallInput input) {
        ClusterManagementApi client = this.createApiClient(input);
        try {
            client.init(new InitCommand().metaStorageNodes(input.getMetaStorageNodes()).cmgNodes(input.getCmgNodes()).clusterName(input.getClusterName()).clusterConfiguration(input.clusterConfiguration()));
            return DefaultCallOutput.success("Cluster was initialized successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getClusterUrl()));
        }
    }

    private ClusterManagementApi createApiClient(ClusterInitCallInput input) {
        return new ClusterManagementApi(this.clientFactory.getClient(input.getClusterUrl()));
    }
}

