/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.node.version;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.NodeManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.NodeVersion;

@Singleton
public class NodeVersionCall
implements Call<UrlCallInput, org.apache.ignite3.internal.rest.api.node.NodeVersion> {
    private final ApiClientFactory clientFactory;

    public NodeVersionCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<org.apache.ignite3.internal.rest.api.node.NodeVersion> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.getNodeVersion(input.getUrl()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private org.apache.ignite3.internal.rest.api.node.NodeVersion getNodeVersion(String url) throws ApiException {
        NodeVersion nodeVersion = new NodeManagementApi(this.clientFactory.getClient(url)).nodeVersion();
        return org.apache.ignite3.internal.rest.api.node.NodeVersion.builder().version(nodeVersion.getVersion()).product(nodeVersion.getProduct()).build();
    }
}

