/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.network.annotations.Transferable;
import org.apache.ignite3.internal.raft.ReadCommand;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

@Transferable(value=30)
public interface GetAllCommand
extends ReadCommand {
    @IgniteStringifier(name="keys.size", value=SizeOnlyStringifier.class)
    public List<ByteBuffer> keys();

    public long revision();

    public static GetAllCommand getAllCommand(MetaStorageCommandsFactory commandsFactory, Set<ByteArray> keys, long revUpperBound) {
        ArrayList<ByteBuffer> keysList = new ArrayList<ByteBuffer>(keys.size());
        for (ByteArray key : keys) {
            keysList.add(ByteBuffer.wrap(key.bytes()));
        }
        return commandsFactory.getAllCommand().keys(keysList).revision(revUpperBound).build();
    }
}

