/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.ReplicatorGroup;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.closure.CatchUpClosure;
import org.apache.ignite3.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite3.raft.jraft.core.NodeImpl;
import org.apache.ignite3.raft.jraft.core.Replicator;
import org.apache.ignite3.raft.jraft.core.ReplicatorType;
import org.apache.ignite3.raft.jraft.entity.NodeId;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.option.ReplicatorGroupOptions;
import org.apache.ignite3.raft.jraft.option.ReplicatorOptions;
import org.apache.ignite3.raft.jraft.rpc.RaftClientService;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;
import org.apache.ignite3.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite3.raft.jraft.util.Describer;
import org.apache.ignite3.raft.jraft.util.OnlyForTest;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.ThreadId;

public class ReplicatorGroupImpl
implements ReplicatorGroup {
    private static final IgniteLogger LOG = Loggers.forClass(ReplicatorGroupImpl.class);
    private final ConcurrentMap<PeerId, ThreadId> replicatorMap = new ConcurrentHashMap<PeerId, ThreadId>();
    private ReplicatorOptions commonOptions;
    private int dynamicTimeoutMs = -1;
    private int electionTimeoutMs = -1;
    private RaftOptions raftOptions;
    private final Map<PeerId, ReplicatorType> failureReplicators = new ConcurrentHashMap<PeerId, ReplicatorType>();
    private final Set<PeerId> failureReplicatorsSetToPreventLogFlooding = ConcurrentHashMap.newKeySet();

    @Override
    public boolean init(NodeId nodeId, ReplicatorGroupOptions opts) {
        this.dynamicTimeoutMs = opts.getHeartbeatTimeoutMs();
        this.electionTimeoutMs = opts.getElectionTimeoutMs();
        this.raftOptions = opts.getRaftOptions();
        this.commonOptions = new ReplicatorOptions();
        this.commonOptions.setDynamicHeartBeatTimeoutMs(this.dynamicTimeoutMs);
        this.commonOptions.setElectionTimeoutMs(this.electionTimeoutMs);
        this.commonOptions.setRaftRpcService(opts.getRaftRpcClientService());
        this.commonOptions.setLogManager(opts.getLogManager());
        this.commonOptions.setBallotBox(opts.getBallotBox());
        this.commonOptions.setNode(opts.getNode());
        this.commonOptions.setTerm(0L);
        this.commonOptions.setGroupId(nodeId.getGroupId());
        this.commonOptions.setServerId(nodeId.getPeerId());
        this.commonOptions.setSnapshotStorage(opts.getSnapshotStorage());
        this.commonOptions.setTimerManager(opts.getTimerManager());
        return true;
    }

    @OnlyForTest
    ConcurrentMap<PeerId, ThreadId> getReplicatorMap() {
        return this.replicatorMap;
    }

    @OnlyForTest
    Map<PeerId, ReplicatorType> getFailureReplicators() {
        return this.failureReplicators;
    }

    @Override
    public void sendHeartbeat(PeerId peer, RpcResponseClosure<RpcRequests.AppendEntriesResponse> closure) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            if (closure != null) {
                closure.run(new Status(RaftError.EHOSTDOWN, "Peer %s is not connected", peer));
            }
            return;
        }
        Replicator.sendHeartbeat(rid, closure, this.commonOptions.getCommonExecutor());
    }

    @Override
    public ThreadId getReplicator(PeerId peer) {
        return (ThreadId)this.replicatorMap.get(peer);
    }

    @Override
    public boolean addReplicator(PeerId peer, ReplicatorType replicatorType, boolean sync) {
        Requires.requireTrue(this.commonOptions.getTerm() != 0L);
        this.failureReplicators.remove(peer);
        if (this.replicatorMap.containsKey(peer)) {
            return true;
        }
        ReplicatorOptions opts = this.commonOptions == null ? new ReplicatorOptions() : this.commonOptions.copy();
        opts.setReplicatorType(replicatorType);
        opts.setPeerId(peer);
        RaftClientService client = opts.getRaftRpcService();
        assert (client != null);
        if (!client.connect(peer)) {
            boolean added = this.failureReplicatorsSetToPreventLogFlooding.add(peer);
            if (added) {
                LOG.error("Fail to check replicator connection to peer [node={}, recipientPeer={}, replicatorType={}].", new Object[]{this.commonOptions.getNode().getNodeId(), peer, replicatorType});
            }
            this.failureReplicators.put(peer, replicatorType);
            return false;
        }
        this.failureReplicatorsSetToPreventLogFlooding.remove(peer);
        ThreadId rid = Replicator.start(opts, this.raftOptions);
        if (rid == null) {
            LOG.error("Fail to start replicator to peer [node={}, recipientPeer={}, replicatorType={}].", new Object[]{this.commonOptions.getNode().getNodeId(), peer, replicatorType});
            this.failureReplicators.put(peer, replicatorType);
            return false;
        }
        return this.replicatorMap.put(peer, rid) == null;
    }

    @Override
    public void clearFailureReplicators() {
        this.failureReplicators.clear();
    }

    @Override
    public boolean waitCaughtUp(PeerId peer, long maxMargin, long dueTime, CatchUpClosure done) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            return false;
        }
        Replicator.waitForCaughtUp(rid, maxMargin, dueTime, done, this.commonOptions.getCommonExecutor());
        return true;
    }

    @Override
    public long getLastRpcSendTimestamp(PeerId peer) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            return 0L;
        }
        return Replicator.getLastRpcSendTimestamp(rid);
    }

    @Override
    public boolean stopAll() {
        ArrayList rids = new ArrayList(this.replicatorMap.values());
        this.replicatorMap.clear();
        this.failureReplicators.clear();
        for (ThreadId rid : rids) {
            Replicator.stop(rid);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkReplicator(PeerId peer, boolean lockNode) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        if (rid == null) {
            NodeImpl node = this.commonOptions.getNode();
            if (lockNode) {
                node.writeLock.lock();
            }
            try {
                ReplicatorType rType;
                if (node.isLeader() && (rType = this.failureReplicators.get(peer)) != null && this.addReplicator(peer, rType, false)) {
                    this.failureReplicators.remove(peer, (Object)rType);
                }
            }
            finally {
                if (lockNode) {
                    node.writeLock.unlock();
                }
            }
        }
    }

    @Override
    public boolean stopReplicator(PeerId peer) {
        LOG.info("Stop replicator to [node={}].", this.commonOptions.getNode().getNodeId());
        this.failureReplicators.remove(peer);
        ThreadId rid = (ThreadId)this.replicatorMap.remove(peer);
        if (rid == null) {
            return false;
        }
        return Replicator.stop(rid);
    }

    @Override
    public boolean resetTerm(long newTerm) {
        if (newTerm <= this.commonOptions.getTerm()) {
            return false;
        }
        this.commonOptions.setTerm(newTerm);
        return true;
    }

    @Override
    public boolean resetHeartbeatInterval(int newIntervalMs) {
        this.dynamicTimeoutMs = newIntervalMs;
        return true;
    }

    @Override
    public boolean resetElectionTimeoutInterval(int newIntervalMs) {
        this.electionTimeoutMs = newIntervalMs;
        return true;
    }

    @Override
    public boolean contains(PeerId peer) {
        return this.replicatorMap.containsKey(peer);
    }

    @Override
    public boolean transferLeadershipTo(PeerId peer, long logIndex) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        return rid != null && Replicator.transferLeadership(rid, logIndex);
    }

    @Override
    public boolean stopTransferLeadership(PeerId peer) {
        ThreadId rid = (ThreadId)this.replicatorMap.get(peer);
        return rid != null && Replicator.stopTransferLeadership(rid);
    }

    @Override
    public ThreadId stopAllAndFindTheNextCandidate(ConfigurationEntry conf) {
        ThreadId candidate = null;
        PeerId candidateId = this.findTheNextCandidate(conf);
        if (candidateId != null) {
            candidate = (ThreadId)this.replicatorMap.get(candidateId);
        } else {
            LOG.info("Fail to find the next candidate [node={}].", this.commonOptions.getNode().getNodeId());
        }
        for (ThreadId r : this.replicatorMap.values()) {
            if (r == candidate) continue;
            Replicator.stop(r);
        }
        this.replicatorMap.clear();
        this.failureReplicators.clear();
        return candidate;
    }

    @Override
    public PeerId findTheNextCandidate(ConfigurationEntry conf) {
        PeerId peerId = null;
        int priority = Integer.MIN_VALUE;
        long maxIndex = -1L;
        for (Map.Entry entry : this.replicatorMap.entrySet()) {
            int nextPriority;
            if (!conf.contains((PeerId)entry.getKey()) || (nextPriority = ((PeerId)entry.getKey()).getPriority()) == 0) continue;
            long nextIndex = Replicator.getNextIndex((ThreadId)entry.getValue());
            if (nextIndex > maxIndex) {
                maxIndex = nextIndex;
                peerId = (PeerId)entry.getKey();
                priority = peerId.getPriority();
                continue;
            }
            if (nextIndex != maxIndex || nextPriority <= priority) continue;
            peerId = (PeerId)entry.getKey();
            priority = peerId.getPriority();
        }
        if (maxIndex == -1L) {
            return null;
        }
        return peerId;
    }

    @Override
    public List<ThreadId> listReplicators() {
        return new ArrayList<ThreadId>(this.replicatorMap.values());
    }

    @Override
    public void describe(Describer.Printer out) {
        out.print("  replicators: ").println(this.replicatorMap.values());
        out.print("  failureReplicators: ").println(this.failureReplicators);
    }
}

