/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.metrics.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.metrics.CharacterFilter;
import org.apache.fluss.metrics.Counter;
import org.apache.fluss.metrics.Gauge;
import org.apache.fluss.metrics.Histogram;
import org.apache.fluss.metrics.Meter;
import org.apache.fluss.metrics.Metric;
import org.apache.fluss.metrics.groups.MetricGroup;
import org.apache.fluss.metrics.jmx.JMXService;
import org.apache.fluss.metrics.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXReporter
implements MetricReporter {
    static final String JMX_DOMAIN_PREFIX = "org.apache.fluss.";
    private static final Logger LOG = LoggerFactory.getLogger(JMXReporter.class);
    private static final CharacterFilter CHARACTER_FILTER = JMXReporter::replaceInvalidChars;
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final Map<Metric, ObjectName> registeredMetrics = new HashMap<Metric, ObjectName>();

    JMXReporter(@Nullable String portsConfig) {
        if (portsConfig != null) {
            JMXService.startInstance(portsConfig);
        }
    }

    public void open(Configuration config) {
    }

    public void close() {
        try {
            JMXService.stopInstance();
        }
        catch (Exception e) {
            LOG.error("Failed to stop JMX service", (Throwable)e);
        }
    }

    @VisibleForTesting
    Optional<Integer> getPort() {
        return JMXService.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        AbstractBean jmxMetric;
        ObjectName jmxName;
        String domain = JMXReporter.generateJmxDomain(metricName, group);
        Hashtable<String, String> table = JMXReporter.generateJmxTable(group.getAllVariables());
        try {
            jmxName = new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException e) {
            LOG.debug("Implementation error. The domain or table does not conform to JMX rules.", (Throwable)e);
            return;
        }
        switch (metric.getMetricType()) {
            case GAUGE: {
                jmxMetric = new JmxGauge((Gauge)metric);
                break;
            }
            case COUNTER: {
                jmxMetric = new JmxCounter((Counter)metric);
                break;
            }
            case HISTOGRAM: {
                jmxMetric = new JmxHistogram((Histogram)metric);
                break;
            }
            case METER: {
                jmxMetric = new JmxMeter((Meter)metric);
                break;
            }
            default: {
                LOG.error("Cannot add unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
                return;
            }
        }
        try {
            JMXReporter e = this;
            synchronized (e) {
                this.mBeanServer.registerMBean(jmxMetric, jmxName);
                this.registeredMetrics.put(metric, jmxName);
            }
        }
        catch (NotCompliantMBeanException e) {
            LOG.debug("Metric did not comply with JMX MBean rules.", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.warn("A metric with the name {} was already registered.", (Object)jmxName, (Object)e);
        }
        catch (Throwable t) {
            LOG.warn("Failed to register metric", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        try {
            JMXReporter jMXReporter = this;
            synchronized (jMXReporter) {
                ObjectName jmxName = this.registeredMetrics.remove(metric);
                if (jmxName != null) {
                    this.mBeanServer.unregisterMBean(jmxName);
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable t) {
            LOG.error("Un-registering metric failed", t);
        }
    }

    static Hashtable<String, String> generateJmxTable(Map<String, String> variables) {
        Hashtable<String, String> ht = new Hashtable<String, String>(variables.size());
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            ht.put(JMXReporter.replaceInvalidChars(variable.getKey()), JMXReporter.replaceInvalidChars(variable.getValue()));
        }
        return ht;
    }

    static String generateJmxDomain(String metricName, MetricGroup group) {
        return JMX_DOMAIN_PREFIX + group.getLogicalScope(CHARACTER_FILTER, '.') + "." + metricName;
    }

    static String replaceInvalidChars(String str) {
        char[] chars = null;
        int strLen = str.length();
        int pos = 0;
        block5: for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '<': 
                case '>': {
                    if (chars != null) continue block5;
                    chars = str.toCharArray();
                    continue block5;
                }
                case ' ': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 95;
                    continue block5;
                }
                case '\'': 
                case '*': 
                case ',': 
                case ':': 
                case ';': 
                case '=': 
                case '?': {
                    if (chars == null) {
                        chars = str.toCharArray();
                    }
                    chars[pos++] = 45;
                    continue block5;
                }
                default: {
                    if (chars != null) {
                        chars[pos] = c;
                    }
                    ++pos;
                }
            }
        }
        return chars == null ? str : new String(chars, 0, pos);
    }

    private static class JmxMeter
    extends AbstractBean
    implements JmxMeterMBean {
        private final Meter meter;

        public JmxMeter(Meter meter) {
            this.meter = meter;
        }

        @Override
        public double getRate() {
            return this.meter.getRate();
        }

        @Override
        public long getCount() {
            return this.meter.getCount();
        }
    }

    public static interface JmxMeterMBean
    extends MetricMBean {
        public double getRate();

        public long getCount();
    }

    private static class JmxHistogram
    extends AbstractBean
    implements JmxHistogramMBean {
        private final Histogram histogram;

        JmxHistogram(Histogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public long getCount() {
            return this.histogram.getCount();
        }

        @Override
        public double getMean() {
            return this.histogram.getStatistics().getMean();
        }

        @Override
        public double getStdDev() {
            return this.histogram.getStatistics().getStdDev();
        }

        @Override
        public long getMax() {
            return this.histogram.getStatistics().getMax();
        }

        @Override
        public long getMin() {
            return this.histogram.getStatistics().getMin();
        }

        @Override
        public double getMedian() {
            return this.histogram.getStatistics().getQuantile(0.5);
        }

        @Override
        public double get75thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.75);
        }

        @Override
        public double get95thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.95);
        }

        @Override
        public double get98thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.98);
        }

        @Override
        public double get99thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.99);
        }

        @Override
        public double get999thPercentile() {
            return this.histogram.getStatistics().getQuantile(0.999);
        }
    }

    public static interface JmxHistogramMBean
    extends MetricMBean {
        public long getCount();

        public double getMean();

        public double getStdDev();

        public long getMax();

        public long getMin();

        public double getMedian();

        public double get75thPercentile();

        public double get95thPercentile();

        public double get98thPercentile();

        public double get99thPercentile();

        public double get999thPercentile();
    }

    private static class JmxGauge
    extends AbstractBean
    implements JmxGaugeMBean {
        private final Gauge<?> gauge;

        JmxGauge(Gauge<?> gauge) {
            this.gauge = gauge;
        }

        @Override
        public Object getValue() {
            return this.gauge.getValue();
        }
    }

    public static interface JmxGaugeMBean
    extends MetricMBean {
        public Object getValue();
    }

    private static class JmxCounter
    extends AbstractBean
    implements JmxCounterMBean {
        private final Counter counter;

        JmxCounter(Counter counter) {
            this.counter = counter;
        }

        @Override
        public long getCount() {
            return this.counter.getCount();
        }
    }

    public static interface JmxCounterMBean
    extends MetricMBean {
        public long getCount();
    }

    private static abstract class AbstractBean
    implements MetricMBean {
        private AbstractBean() {
        }
    }

    public static interface MetricMBean {
    }
}

