/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.org.apache.commons.configuration2.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import org.apache.fluss.shaded.org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.fluss.shaded.org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.fluss.shaded.org.apache.commons.configuration2.io.DefaultFileSystem;
import org.apache.fluss.shaded.org.apache.commons.configuration2.io.FileOptionsProvider;
import org.apache.fluss.shaded.org.apache.commons.logging.Log;
import org.apache.fluss.shaded.org.apache.commons.logging.LogFactory;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileContent;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileName;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileObject;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileSystemException;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileSystemManager;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileSystemOptions;
import org.apache.fluss.shaded.org.apache.commons.vfs2.FileType;
import org.apache.fluss.shaded.org.apache.commons.vfs2.VFS;
import org.apache.fluss.shaded.org.apache.commons.vfs2.provider.UriParser;

public class VFSFileSystem
extends DefaultFileSystem {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public InputStream getInputStream(URL url) throws ConfigurationException {
        try {
            FileObject file;
            FileSystemOptions opts = this.getOptions(url.getProtocol());
            FileObject fileObject = file = opts == null ? VFS.getManager().resolveFile(url.toString()) : VFS.getManager().resolveFile(url.toString(), opts);
            if (file.getType() != FileType.FILE) {
                throw new ConfigurationException("Cannot load a configuration from a directory");
            }
            FileContent content = file.getContent();
            if (content == null) {
                String msg = "Cannot access content of " + file.getName().getFriendlyURI();
                throw new ConfigurationException(msg);
            }
            return content.getInputStream();
        }
        catch (FileSystemException fse) {
            String msg = "Unable to access " + url.toString();
            throw new ConfigurationException(msg, fse);
        }
    }

    @Override
    public OutputStream getOutputStream(URL url) throws ConfigurationException {
        try {
            FileObject file;
            FileSystemOptions opts = this.getOptions(url.getProtocol());
            FileSystemManager fsManager = VFS.getManager();
            FileObject fileObject = file = opts == null ? fsManager.resolveFile(url.toString()) : fsManager.resolveFile(url.toString(), opts);
            if (file == null || file.getType() == FileType.FOLDER) {
                throw new ConfigurationException("Cannot save a configuration to a directory");
            }
            FileContent content = file.getContent();
            if (content == null) {
                throw new ConfigurationException("Cannot access content of " + url);
            }
            return content.getOutputStream();
        }
        catch (FileSystemException fse) {
            throw new ConfigurationException("Unable to access " + url, fse);
        }
    }

    @Override
    public String getPath(File file, URL url, String basePath, String fileName) {
        if (file != null) {
            return super.getPath(file, url, basePath, fileName);
        }
        try {
            FileName name;
            FileSystemManager fsManager = VFS.getManager();
            if (url != null && (name = fsManager.resolveURI(url.toString())) != null) {
                return name.toString();
            }
            if (UriParser.extractScheme((String)fileName) != null) {
                return fileName;
            }
            if (basePath != null) {
                FileName base = fsManager.resolveURI(basePath);
                return fsManager.resolveName(base, fileName).getURI();
            }
            name = fsManager.resolveURI(fileName);
            FileName base = name.getParent();
            return fsManager.resolveName(base, name.getBaseName()).getURI();
        }
        catch (FileSystemException fse) {
            fse.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBasePath(String path) {
        if (UriParser.extractScheme((String)path) == null) {
            return super.getBasePath(path);
        }
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileName name = fsManager.resolveURI(path);
            return name.getParent().getURI();
        }
        catch (FileSystemException fse) {
            fse.printStackTrace();
            return null;
        }
    }

    @Override
    public String getFileName(String path) {
        if (UriParser.extractScheme((String)path) == null) {
            return super.getFileName(path);
        }
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileName name = fsManager.resolveURI(path);
            return name.getBaseName();
        }
        catch (FileSystemException fse) {
            fse.printStackTrace();
            return null;
        }
    }

    @Override
    public URL getURL(String basePath, String file) throws MalformedURLException {
        if (basePath != null && UriParser.extractScheme((String)basePath) == null || basePath == null && UriParser.extractScheme((String)file) == null) {
            return super.getURL(basePath, file);
        }
        try {
            FileName path;
            FileSystemManager fsManager = VFS.getManager();
            if (basePath != null && UriParser.extractScheme((String)file) == null) {
                FileName base = fsManager.resolveURI(basePath);
                path = fsManager.resolveName(base, file);
            } else {
                path = fsManager.resolveURI(file);
            }
            VFSURLStreamHandler handler = new VFSURLStreamHandler(path);
            return new URL(null, path.getURI(), handler);
        }
        catch (FileSystemException fse) {
            throw new ConfigurationRuntimeException("Could not parse basePath: " + basePath + " and fileName: " + file, fse);
        }
    }

    @Override
    public URL locateFromURL(String basePath, String fileName) {
        String fileScheme = UriParser.extractScheme((String)fileName);
        if ((basePath == null || UriParser.extractScheme((String)basePath) == null) && fileScheme == null) {
            return super.locateFromURL(basePath, fileName);
        }
        try {
            FileObject file;
            FileSystemManager fsManager = VFS.getManager();
            if (basePath != null && fileScheme == null) {
                FileObject base;
                String scheme = UriParser.extractScheme((String)basePath);
                FileSystemOptions opts = scheme != null ? this.getOptions(scheme) : null;
                FileObject fileObject = base = opts == null ? fsManager.resolveFile(basePath) : fsManager.resolveFile(basePath, opts);
                if (base.getType() == FileType.FILE) {
                    base = base.getParent();
                }
                file = fsManager.resolveFile(base, fileName);
            } else {
                FileSystemOptions opts = fileScheme != null ? this.getOptions(fileScheme) : null;
                FileObject fileObject = file = opts == null ? fsManager.resolveFile(fileName) : fsManager.resolveFile(fileName, opts);
            }
            if (!file.exists()) {
                return null;
            }
            FileName path = file.getName();
            VFSURLStreamHandler handler = new VFSURLStreamHandler(path);
            return new URL(null, path.getURI(), handler);
        }
        catch (FileSystemException fse) {
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private FileSystemOptions getOptions(String scheme) {
        FileSystemConfigBuilder builder;
        FileSystemOptions opts = new FileSystemOptions();
        try {
            builder = VFS.getManager().getFileSystemConfigBuilder(scheme);
        }
        catch (Exception ex) {
            return null;
        }
        FileOptionsProvider provider = this.getFileOptionsProvider();
        if (provider != null) {
            Map<String, Object> map = provider.getOptions();
            if (map == null) {
                return null;
            }
            int count = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                try {
                    String key = entry.getKey();
                    if ("currentUser".equals(key)) {
                        key = "creatorName";
                    }
                    this.setProperty(builder, opts, key, entry.getValue());
                    ++count;
                }
                catch (Exception ex) {}
            }
            if (count > 0) {
                return opts;
            }
        }
        return null;
    }

    private void setProperty(FileSystemConfigBuilder builder, FileSystemOptions options, String key, Object value) {
        String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
        Class[] paramTypes = new Class[]{FileSystemOptions.class, value.getClass()};
        try {
            Method method = builder.getClass().getMethod(methodName, paramTypes);
            Object[] params = new Object[]{options, value};
            method.invoke((Object)builder, params);
        }
        catch (Exception ex) {
            this.log.warn("Cannot access property '" + key + "'! Ignoring.", ex);
        }
    }

    private static class VFSURLStreamHandler
    extends URLStreamHandler {
        private final String protocol;

        public VFSURLStreamHandler(FileName file) {
            this.protocol = file.getScheme();
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            throw new IOException("VFS URLs can only be used with VFS APIs");
        }
    }
}

