/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.io.IOException;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.lake.committer.CommitterInitContext;
import org.apache.fluss.lake.committer.LakeCommitter;
import org.apache.fluss.lake.paimon.tiering.PaimonCatalogProvider;
import org.apache.fluss.lake.paimon.tiering.PaimonCommittable;
import org.apache.fluss.lake.paimon.tiering.PaimonCommittableSerializer;
import org.apache.fluss.lake.paimon.tiering.PaimonLakeCommitter;
import org.apache.fluss.lake.paimon.tiering.PaimonLakeWriter;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResult;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResultSerializer;
import org.apache.fluss.lake.serializer.SimpleVersionedSerializer;
import org.apache.fluss.lake.writer.LakeTieringFactory;
import org.apache.fluss.lake.writer.LakeWriter;
import org.apache.fluss.lake.writer.WriterInitContext;

public class PaimonLakeTieringFactory
implements LakeTieringFactory<PaimonWriteResult, PaimonCommittable> {
    private static final long serialVersionUID = 1L;
    private final PaimonCatalogProvider paimonCatalogProvider;

    public PaimonLakeTieringFactory(Configuration paimonConfig) {
        this.paimonCatalogProvider = new PaimonCatalogProvider(paimonConfig);
    }

    public LakeWriter<PaimonWriteResult> createLakeWriter(WriterInitContext writerInitContext) throws IOException {
        return new PaimonLakeWriter(this.paimonCatalogProvider, writerInitContext);
    }

    public SimpleVersionedSerializer<PaimonWriteResult> getWriteResultSerializer() {
        return new PaimonWriteResultSerializer();
    }

    public LakeCommitter<PaimonWriteResult, PaimonCommittable> createLakeCommitter(CommitterInitContext committerInitContext) throws IOException {
        return new PaimonLakeCommitter(this.paimonCatalogProvider, committerInitContext.tablePath());
    }

    public SimpleVersionedSerializer<PaimonCommittable> getCommittableSerializer() {
        return new PaimonCommittableSerializer();
    }
}

