/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

public enum BlockCompressionType {
    NONE(0),
    ZSTD(1),
    LZ4(2),
    LZO(3);

    private final int persistentId;

    private BlockCompressionType(int persistentId) {
        this.persistentId = persistentId;
    }

    public int persistentId() {
        return this.persistentId;
    }

    public static BlockCompressionType getCompressionTypeByPersistentId(int persistentId) {
        BlockCompressionType[] types;
        for (BlockCompressionType type : types = BlockCompressionType.values()) {
            if (type.persistentId != persistentId) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown persistentId " + persistentId);
    }
}

