/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.lang.reflect.Array;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryArrayWriter;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.DataType;

@Public
public final class BinaryArray
extends BinarySection
implements InternalArray,
DataSetters {
    private static final long serialVersionUID = 1L;
    private static final int BYTE_ARRAY_BASE_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(byte[].class);
    private static final int BOOLEAN_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(boolean[].class);
    private static final int SHORT_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(short[].class);
    private static final int INT_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(int[].class);
    private static final int LONG_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(long[].class);
    private static final int FLOAT_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(float[].class);
    private static final int DOUBLE_ARRAY_OFFSET = MemorySegment.UNSAFE.arrayBaseOffset(double[].class);
    private transient int size;
    private transient int elementOffset;

    public static int calculateHeaderInBytes(int numFields) {
        return 4 + (numFields + 31) / 32 * 4;
    }

    public static int calculateFixLengthPartSize(DataType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: {
                return 1;
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case BIGINT: 
            case DOUBLE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case VARIANT: {
                return 8;
            }
            case SMALLINT: {
                return 2;
            }
            case INTEGER: 
            case FLOAT: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private void assertIndexIsValid(int ordinal) {
        assert (ordinal >= 0) : "ordinal (" + ordinal + ") should >= 0";
        assert (ordinal < this.size) : "ordinal (" + ordinal + ") should < " + this.size;
    }

    private int getElementOffset(int ordinal, int elementSize) {
        return this.elementOffset + ordinal * elementSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int size = MemorySegmentUtils.getInt(segments, offset);
        assert (size >= 0) : "size (" + size + ") should >= 0";
        this.size = size;
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
        this.elementOffset = offset + BinaryArray.calculateHeaderInBytes(this.size);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.bitGet(this.segments, this.offset + 4, pos);
    }

    @Override
    public void setNullAt(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
    }

    public void setNotNullAt(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitUnSet(this.segments, this.offset + 4, pos);
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setLong(this.segments, this.getElementOffset(pos, 8), value);
    }

    public void setNullLong(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setLong(this.segments, this.getElementOffset(pos, 8), 0L);
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getInt(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setInt(this.segments, this.getElementOffset(pos, 4), value);
    }

    public void setNullInt(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setInt(this.segments, this.getElementOffset(pos, 4), 0);
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readBinaryString(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(MemorySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8)), precision, scale);
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readDecimal(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            return Timestamp.fromEpochMillis(MemorySegmentUtils.getLong(this.segments, this.getElementOffset(pos, 8)));
        }
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndNanoOfMilli = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndSize);
    }

    @Override
    public Variant getVariant(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndLen = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readVariant(this.segments, this.offset, offsetAndLen);
    }

    @Override
    public InternalArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public InternalMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getElementOffset(pos, 8);
        long offsetAndSize = MemorySegmentUtils.getLong(this.segments, fieldOffset);
        return MemorySegmentUtils.readRowData(this.segments, numFields, this.offset, offsetAndSize);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getBoolean(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setBoolean(this.segments, this.getElementOffset(pos, 1), value);
    }

    public void setNullBoolean(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setBoolean(this.segments, this.getElementOffset(pos, 1), false);
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getByte(this.segments, this.getElementOffset(pos, 1));
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setByte(this.segments, this.getElementOffset(pos, 1), value);
    }

    public void setNullByte(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setByte(this.segments, this.getElementOffset(pos, 1), (byte)0);
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getShort(this.segments, this.getElementOffset(pos, 2));
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setShort(this.segments, this.getElementOffset(pos, 2), value);
    }

    public void setNullShort(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setShort(this.segments, this.getElementOffset(pos, 2), (short)0);
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getFloat(this.segments, this.getElementOffset(pos, 4));
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setFloat(this.segments, this.getElementOffset(pos, 4), value);
    }

    public void setNullFloat(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setFloat(this.segments, this.getElementOffset(pos, 4), 0.0f);
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.getDouble(this.segments, this.getElementOffset(pos, 8));
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        MemorySegmentUtils.setDouble(this.segments, this.getElementOffset(pos, 8), value);
    }

    public void setNullDouble(int pos) {
        this.assertIndexIsValid(pos);
        MemorySegmentUtils.bitSet(this.segments, this.offset + 4, pos);
        MemorySegmentUtils.setDouble(this.segments, this.getElementOffset(pos, 8), 0.0);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(MemorySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                MemorySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                MemorySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, Timestamp value, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            this.setLong(pos, value.getMillisecond());
        } else {
            int fieldOffset = this.getElementOffset(pos, 8);
            int cursor = (int)(MemorySegmentUtils.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value == null) {
                this.setNullAt(pos);
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                MemorySegmentUtils.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, value.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value.getNanoOfMillisecond());
            }
        }
    }

    public boolean anyNull() {
        for (int i = this.offset + 4; i < this.elementOffset; i += 4) {
            if (MemorySegmentUtils.getInt(this.segments, i) == 0) continue;
            return true;
        }
        return false;
    }

    private void checkNoNull() {
        if (this.anyNull()) {
            throw new RuntimeException("Primitive array must not contain a null value.");
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        this.checkNoNull();
        boolean[] values2 = new boolean[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, BOOLEAN_ARRAY_OFFSET, this.size);
        return values2;
    }

    @Override
    public byte[] toByteArray() {
        this.checkNoNull();
        byte[] values2 = new byte[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, BYTE_ARRAY_BASE_OFFSET, this.size);
        return values2;
    }

    @Override
    public short[] toShortArray() {
        this.checkNoNull();
        short[] values2 = new short[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, SHORT_ARRAY_OFFSET, this.size * 2);
        return values2;
    }

    @Override
    public int[] toIntArray() {
        this.checkNoNull();
        int[] values2 = new int[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, INT_ARRAY_OFFSET, this.size * 4);
        return values2;
    }

    @Override
    public long[] toLongArray() {
        this.checkNoNull();
        long[] values2 = new long[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, LONG_ARRAY_OFFSET, this.size * 8);
        return values2;
    }

    @Override
    public float[] toFloatArray() {
        this.checkNoNull();
        float[] values2 = new float[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, FLOAT_ARRAY_OFFSET, this.size * 4);
        return values2;
    }

    @Override
    public double[] toDoubleArray() {
        this.checkNoNull();
        double[] values2 = new double[this.size];
        MemorySegmentUtils.copyToUnsafe(this.segments, this.elementOffset, values2, DOUBLE_ARRAY_OFFSET, this.size * 8);
        return values2;
    }

    public <T> T[] toObjectArray(DataType elementType) {
        Class<?> elementClass = InternalRow.getDataClass(elementType);
        InternalArray.ElementGetter elementGetter = InternalArray.createElementGetter(elementType);
        Object[] values2 = (Object[])Array.newInstance(elementClass, this.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.isNullAt(i)) continue;
            values2[i] = elementGetter.getElementOrNull(this, i);
        }
        return values2;
    }

    public BinaryArray copy() {
        return this.copy(new BinaryArray());
    }

    public BinaryArray copy(BinaryArray reuse) {
        byte[] bytes = MemorySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return MemorySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryArray fromPrimitiveArray(boolean[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BOOLEAN_ARRAY_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(byte[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, BYTE_ARRAY_BASE_OFFSET, arr.length, 1);
    }

    public static BinaryArray fromPrimitiveArray(short[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, SHORT_ARRAY_OFFSET, arr.length, 2);
    }

    public static BinaryArray fromPrimitiveArray(int[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, INT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(long[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, LONG_ARRAY_OFFSET, arr.length, 8);
    }

    public static BinaryArray fromPrimitiveArray(float[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, FLOAT_ARRAY_OFFSET, arr.length, 4);
    }

    public static BinaryArray fromPrimitiveArray(double[] arr) {
        return BinaryArray.fromPrimitiveArray(arr, DOUBLE_ARRAY_OFFSET, arr.length, 8);
    }

    private static BinaryArray fromPrimitiveArray(Object arr, int offset, int length, int elementSize) {
        long valueRegionInBytes;
        long headerInBytes = BinaryArray.calculateHeaderInBytes(length);
        long totalSizeInLongs = (headerInBytes + (valueRegionInBytes = (long)(elementSize * length)) + 7L) / 8L;
        if (totalSizeInLongs > 0xFFFFFFFL) {
            throw new UnsupportedOperationException("Cannot convert this array to unsafe format as it's too big.");
        }
        long totalSize = totalSizeInLongs * 8L;
        byte[] data = new byte[(int)totalSize];
        MemorySegment.UNSAFE.putInt(data, BYTE_ARRAY_BASE_OFFSET, length);
        MemorySegment.UNSAFE.copyMemory(arr, offset, data, (long)BYTE_ARRAY_BASE_OFFSET + headerInBytes, valueRegionInBytes);
        BinaryArray result = new BinaryArray();
        result.pointTo(MemorySegment.wrap(data), 0, (int)totalSize);
        return result;
    }

    public static BinaryArray fromLongArray(Long[] arr) {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, arr.length, 8);
        for (int i = 0; i < arr.length; ++i) {
            Long v = arr[i];
            if (v == null) {
                writer.setNullLong(i);
                continue;
            }
            writer.writeLong(i, v);
        }
        writer.complete();
        return array;
    }

    public static BinaryArray fromLongArray(InternalArray arr) {
        if (arr instanceof BinaryArray) {
            return (BinaryArray)arr;
        }
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, arr.size(), 8);
        for (int i = 0; i < arr.size(); ++i) {
            if (arr.isNullAt(i)) {
                writer.setNullLong(i);
                continue;
            }
            writer.writeLong(i, arr.getLong(i));
        }
        writer.complete();
        return array;
    }
}

