/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryArrayWriter;
import org.apache.paimon.data.BinaryMap;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.DataType;

public class InternalMapSerializer
implements Serializer<InternalMap> {
    private final DataType keyType;
    private final DataType valueType;
    private final Serializer keySerializer;
    private final Serializer valueSerializer;
    private final InternalArray.ElementGetter keyGetter;
    private final InternalArray.ElementGetter valueGetter;
    private transient BinaryArray reuseKeyArray;
    private transient BinaryArray reuseValueArray;
    private transient BinaryArrayWriter reuseKeyWriter;
    private transient BinaryArrayWriter reuseValueWriter;

    public InternalMapSerializer(DataType keyType, DataType valueType) {
        this(keyType, valueType, InternalSerializers.create(keyType), InternalSerializers.create(valueType));
    }

    private InternalMapSerializer(DataType keyType, DataType valueType, Serializer keySerializer, Serializer valueSerializer) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyGetter = InternalArray.createElementGetter(keyType);
        this.valueGetter = InternalArray.createElementGetter(valueType);
    }

    @Override
    public Serializer<InternalMap> duplicate() {
        return new InternalMapSerializer(this.keyType, this.valueType, this.keySerializer.duplicate(), this.valueSerializer.duplicate());
    }

    @Override
    public InternalMap copy(InternalMap from) {
        if (from instanceof BinaryMap) {
            return ((BinaryMap)from).copy();
        }
        return this.toBinaryMap(from);
    }

    @Override
    public void serialize(InternalMap record, DataOutputView target) throws IOException {
        BinaryMap binaryMap = this.toBinaryMap(record);
        target.writeInt(binaryMap.getSizeInBytes());
        MemorySegmentUtils.copyToView(binaryMap.getSegments(), binaryMap.getOffset(), binaryMap.getSizeInBytes(), target);
    }

    public BinaryMap toBinaryMap(InternalMap from) {
        if (from instanceof BinaryMap) {
            return (BinaryMap)from;
        }
        int numElements = from.size();
        if (this.reuseKeyArray == null) {
            this.reuseKeyArray = new BinaryArray();
        }
        if (this.reuseValueArray == null) {
            this.reuseValueArray = new BinaryArray();
        }
        if (this.reuseKeyWriter == null || this.reuseKeyWriter.getNumElements() != numElements) {
            this.reuseKeyWriter = new BinaryArrayWriter(this.reuseKeyArray, numElements, BinaryArray.calculateFixLengthPartSize(this.keyType));
        } else {
            this.reuseKeyWriter.reset();
        }
        if (this.reuseValueWriter == null || this.reuseValueWriter.getNumElements() != numElements) {
            this.reuseValueWriter = new BinaryArrayWriter(this.reuseValueArray, numElements, BinaryArray.calculateFixLengthPartSize(this.valueType));
        } else {
            this.reuseValueWriter.reset();
        }
        InternalArray keyArray = from.keyArray();
        InternalArray valueArray = from.valueArray();
        for (int i = 0; i < from.size(); ++i) {
            Object key = this.keyGetter.getElementOrNull(keyArray, i);
            Object value = this.valueGetter.getElementOrNull(valueArray, i);
            if (key == null) {
                this.reuseKeyWriter.setNullAt(i, this.keyType);
            } else {
                BinaryWriter.write(this.reuseKeyWriter, i, key, this.keyType, this.keySerializer);
            }
            if (value == null) {
                this.reuseValueWriter.setNullAt(i, this.valueType);
                continue;
            }
            BinaryWriter.write(this.reuseValueWriter, i, value, this.valueType, this.valueSerializer);
        }
        this.reuseKeyWriter.complete();
        this.reuseValueWriter.complete();
        return BinaryMap.valueOf(this.reuseKeyArray, this.reuseValueArray);
    }

    @Override
    public InternalMap deserialize(DataInputView source2) throws IOException {
        return this.deserializeReuse(new BinaryMap(), source2);
    }

    private BinaryMap deserializeReuse(BinaryMap reuse, DataInputView source2) throws IOException {
        int length = source2.readInt();
        byte[] bytes = new byte[length];
        source2.readFully(bytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, bytes.length);
        return reuse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMapSerializer that = (InternalMapSerializer)o;
        return this.keyType.equals(that.keyType) && this.valueType.equals(that.valueType);
    }

    public int hashCode() {
        int result = this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public static Map<Object, Object> convertToJavaMap(InternalMap map, DataType keyType, DataType valueType) {
        InternalArray keyArray = map.keyArray();
        InternalArray valueArray = map.valueArray();
        HashMap<Object, Object> javaMap = new HashMap<Object, Object>();
        InternalArray.ElementGetter keyGetter = InternalArray.createElementGetter(keyType);
        InternalArray.ElementGetter valueGetter = InternalArray.createElementGetter(valueType);
        for (int i = 0; i < map.size(); ++i) {
            Object key = keyGetter.getElementOrNull(keyArray, i);
            Object value = valueGetter.getElementOrNull(valueArray, i);
            javaMap.put(key, value);
        }
        return javaMap;
    }
}

