/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.concurrent.TimeUnit;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.description.Description;
import org.apache.paimon.options.description.TextElement;

public final class HiveCatalogOptions {
    public static final String IDENTIFIER = "hive";
    public static final ConfigOption<String> HIVE_CONF_DIR = ConfigOptions.key("hive-conf-dir").stringType().noDefaultValue().withDescription("File directory of the hive-site.xml , used to create HiveMetastoreClient and security authentication, such as Kerberos, LDAP, Ranger and so on.\nIf not configured, try to load from 'HIVE_CONF_DIR' env.\n");
    public static final ConfigOption<String> HADOOP_CONF_DIR = ConfigOptions.key("hadoop-conf-dir").stringType().noDefaultValue().withDescription("File directory of the core-site.xml\u3001hdfs-site.xml\u3001yarn-site.xml\u3001mapred-site.xml. Currently, only local file system paths are supported.\nIf not configured, try to load from 'HADOOP_CONF_DIR' or 'HADOOP_HOME' system environment.\nConfigure Priority: 1.from 'hadoop-conf-dir' 2.from HADOOP_CONF_DIR  3.from HADOOP_HOME/conf 4.HADOOP_HOME/etc/hadoop.\n");
    public static final ConfigOption<String> METASTORE_CLIENT_CLASS = ConfigOptions.key("metastore.client.class").stringType().defaultValue("org.apache.hadoop.hive.metastore.HiveMetaStoreClient").withDescription("Class name of Hive metastore client.\nNOTE: This class must directly implements org.apache.hadoop.hive.metastore.IMetaStoreClient.");
    public static final ConfigOption<Boolean> LOCATION_IN_PROPERTIES = ConfigOptions.key("location-in-properties").booleanType().defaultValue(false).withDescription("Setting the location in properties of hive table/database.\nIf you don't want to access the location by the filesystem of hive when using a object storage such as s3,oss\nyou can set this option to true.\n");
    public static final ConfigOption<Long> CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS = ConfigOptions.key("client-pool-cache.eviction-interval-ms").longType().defaultValue(TimeUnit.MINUTES.toMillis(5L)).withDescription("Setting the client's pool cache eviction interval(ms).\n");
    public static final ConfigOption<String> CLIENT_POOL_CACHE_KEYS = ConfigOptions.key("client-pool-cache.keys").stringType().noDefaultValue().withDescription(Description.builder().text("Specify client cache key, multiple elements separated by commas.").linebreak().list(TextElement.text("\"ugi\":  the Hadoop UserGroupInformation instance that represents the current user using the cache.")).list(TextElement.text("\"user_name\" similar to UGI but only includes the user's name determined by UserGroupInformation#getUserName.")).list(TextElement.text("\"conf\": name of an arbitrary configuration. The value of the configuration will be extracted from catalog properties and added to the cache key. A conf element should start with a \"conf:\" prefix which is followed by the configuration name. E.g. specifying \"conf:a.b.c\" will add \"a.b.c\" to the key, and so that configurations with different default catalog wouldn't share the same client pool. Multiple conf elements can be specified.")).build());

    private HiveCatalogOptions() {
    }
}

