/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMeta;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;

public class IcebergDataFileMetaSerializer
extends ObjectSerializer<IcebergDataFileMeta> {
    private static final long serialVersionUID = 1L;
    private final InternalRowSerializer partSerializer;
    private final InternalMapSerializer nullValueCountsSerializer;
    private final InternalMapSerializer lowerBoundsSerializer;
    private final InternalMapSerializer upperBoundsSerializer;

    public IcebergDataFileMetaSerializer(RowType partitionType) {
        super(IcebergDataFileMeta.schema(partitionType));
        this.partSerializer = new InternalRowSerializer(partitionType);
        this.nullValueCountsSerializer = new InternalMapSerializer(DataTypes.INT(), DataTypes.BIGINT());
        this.lowerBoundsSerializer = new InternalMapSerializer(DataTypes.INT(), DataTypes.BYTES());
        this.upperBoundsSerializer = new InternalMapSerializer(DataTypes.INT(), DataTypes.BYTES());
    }

    @Override
    public InternalRow toRow(IcebergDataFileMeta file) {
        return GenericRow.of(file.content().id(), BinaryString.fromString(file.filePath()), BinaryString.fromString(file.fileFormat()), file.partition(), file.recordCount(), file.fileSizeInBytes(), file.nullValueCounts(), file.lowerBounds(), file.upperBounds(), BinaryString.fromString(file.referencedDataFile()), file.contentOffset(), file.contentSizeInBytes());
    }

    @Override
    public IcebergDataFileMeta fromRow(InternalRow row) {
        return new IcebergDataFileMeta(IcebergDataFileMeta.Content.fromId(row.getInt(0)), row.getString(1).toString(), row.getString(2).toString(), this.partSerializer.toBinaryRow(row.getRow(3, this.partSerializer.getArity())).copy(), row.getLong(4), row.getLong(5), this.nullValueCountsSerializer.copy(row.getMap(6)), this.lowerBoundsSerializer.copy(row.getMap(7)), this.upperBoundsSerializer.copy(row.getMap(8)), row.isNullAt(9) ? null : row.getString(9).toString(), row.isNullAt(10) ? null : Long.valueOf(row.getLong(10)), row.isNullAt(11) ? null : Long.valueOf(row.getLong(11)));
    }
}

