/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummary;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummarySerializer;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;

public class IcebergManifestFileMetaSerializer
extends ObjectSerializer<IcebergManifestFileMeta> {
    private static final long serialVersionUID = 1L;
    private final IcebergPartitionSummarySerializer partitionSummarySerializer = new IcebergPartitionSummarySerializer();

    public IcebergManifestFileMetaSerializer(RowType schema) {
        super(schema);
    }

    @Override
    public InternalRow toRow(IcebergManifestFileMeta file) {
        Object[] objectArray = new Object[14];
        objectArray[0] = BinaryString.fromString(file.manifestPath());
        objectArray[1] = file.manifestLength();
        objectArray[2] = file.partitionSpecId();
        objectArray[3] = file.content().id();
        objectArray[4] = file.sequenceNumber();
        objectArray[5] = file.minSequenceNumber();
        objectArray[6] = file.addedSnapshotId();
        objectArray[7] = file.addedFilesCount();
        objectArray[8] = file.existingFilesCount();
        objectArray[9] = file.deletedFilesCount();
        objectArray[10] = file.addedRowsCount();
        objectArray[11] = file.existingRowsCount();
        objectArray[12] = file.deletedRowsCount();
        objectArray[13] = new GenericArray(file.partitions().stream().map(this.partitionSummarySerializer::toRow).toArray(InternalRow[]::new));
        return GenericRow.of(objectArray);
    }

    @Override
    public IcebergManifestFileMeta fromRow(InternalRow row) {
        return new IcebergManifestFileMeta(row.getString(0).toString(), row.getLong(1), row.getInt(2), IcebergManifestFileMeta.Content.fromId(row.getInt(3)), row.getLong(4), row.getLong(5), row.getLong(6), row.getInt(7), row.getInt(8), row.getInt(9), row.getLong(10), row.getLong(11), row.getLong(12), this.toPartitionSummaries(row.getArray(13)));
    }

    private List<IcebergPartitionSummary> toPartitionSummaries(InternalArray array) {
        ArrayList<IcebergPartitionSummary> summaries = new ArrayList<IcebergPartitionSummary>();
        for (int i = 0; i < array.size(); ++i) {
            summaries.add(this.partitionSummarySerializer.fromRow(array.getRow(i, this.partitionSummarySerializer.numFields())));
        }
        return summaries;
    }
}

