/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class IcebergPartitionSummary {
    private final boolean containsNull;
    private final boolean containsNan;
    private final byte[] lowerBound;
    private final byte[] upperBound;

    public IcebergPartitionSummary(boolean containsNull, boolean containsNan, byte[] lowerBound, byte[] upperBound) {
        this.containsNull = containsNull;
        this.containsNan = containsNan;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean containsNan() {
        return this.containsNan;
    }

    public byte[] lowerBound() {
        return this.lowerBound;
    }

    public byte[] upperBound() {
        return this.upperBound;
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(509, "contains_null", DataTypes.BOOLEAN().notNull()));
        fields.add(new DataField(518, "contains_nan", DataTypes.BOOLEAN()));
        fields.add(new DataField(510, "lower_bound", DataTypes.BYTES()));
        fields.add(new DataField(511, "upper_bound", DataTypes.BYTES()));
        return new RowType(false, fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergPartitionSummary that = (IcebergPartitionSummary)o;
        return this.containsNull == that.containsNull && this.containsNan == that.containsNan && Arrays.equals(this.lowerBound, that.lowerBound) && Arrays.equals(this.upperBound, that.upperBound);
    }

    public int hashCode() {
        int result = Objects.hash(this.containsNull, this.containsNan);
        result = 31 * result + Arrays.hashCode(this.lowerBound);
        result = 31 * result + Arrays.hashCode(this.upperBound);
        return result;
    }
}

