/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.metadata.IcebergPartitionSpec;
import org.apache.paimon.iceberg.metadata.IcebergRef;
import org.apache.paimon.iceberg.metadata.IcebergSchema;
import org.apache.paimon.iceberg.metadata.IcebergSnapshot;
import org.apache.paimon.iceberg.metadata.IcebergSortOrder;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.JsonSerdeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergMetadata {
    public static final int FORMAT_VERSION_V2 = 2;
    public static final int FORMAT_VERSION_V3 = 3;
    private static final String FIELD_FORMAT_VERSION = "format-version";
    private static final String FIELD_TABLE_UUID = "table-uuid";
    private static final String FIELD_LOCATION = "location";
    private static final String FIELD_LAST_SEQUENCE_NUMBER = "last-sequence-number";
    private static final String FIELD_LAST_UPDATED_MS = "last-updated-ms";
    private static final String FIELD_LAST_COLUMN_ID = "last-column-id";
    private static final String FIELD_SCHEMAS = "schemas";
    private static final String FIELD_CURRENT_SCHEMA_ID = "current-schema-id";
    private static final String FIELD_PARTITION_SPECS = "partition-specs";
    private static final String FIELD_DEFAULT_SPEC_ID = "default-spec-id";
    private static final String FIELD_LAST_PARTITION_ID = "last-partition-id";
    private static final String FIELD_SORT_ORDERS = "sort-orders";
    private static final String FIELD_DEFAULT_SORT_ORDER_ID = "default-sort-order-id";
    private static final String FIELD_SNAPSHOTS = "snapshots";
    private static final String FIELD_CURRENT_SNAPSHOT_ID = "current-snapshot-id";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_REFS = "refs";
    @JsonProperty(value="format-version")
    private final int formatVersion;
    @JsonProperty(value="table-uuid")
    private final String tableUuid;
    @JsonProperty(value="location")
    private final String location;
    @JsonProperty(value="last-sequence-number")
    private final long lastSequenceNumber;
    @JsonProperty(value="last-updated-ms")
    private final long lastUpdatedMs;
    @JsonProperty(value="last-column-id")
    private final int lastColumnId;
    @JsonProperty(value="schemas")
    private final List<IcebergSchema> schemas;
    @JsonProperty(value="current-schema-id")
    private final int currentSchemaId;
    @JsonProperty(value="partition-specs")
    private final List<IcebergPartitionSpec> partitionSpecs;
    @JsonProperty(value="default-spec-id")
    private final int defaultSpecId;
    @JsonProperty(value="last-partition-id")
    private final int lastPartitionId;
    @JsonProperty(value="sort-orders")
    private final List<IcebergSortOrder> sortOrders;
    @JsonProperty(value="default-sort-order-id")
    private final int defaultSortOrderId;
    @JsonProperty(value="snapshots")
    private final List<IcebergSnapshot> snapshots;
    @JsonProperty(value="current-snapshot-id")
    private final long currentSnapshotId;
    @JsonProperty(value="properties")
    @Nullable
    private final Map<String, String> properties;
    @JsonProperty(value="refs")
    @Nullable
    private final Map<String, IcebergRef> refs;

    public IcebergMetadata(int formatVersion, String tableUuid, String location, long lastSequenceNumber, int lastColumnId, List<IcebergSchema> schemas, int currentSchemaId, List<IcebergPartitionSpec> partitionSpecs, int lastPartitionId, List<IcebergSnapshot> snapshots2, long currentSnapshotId, @Nullable Map<String, IcebergRef> refs) {
        this(formatVersion, tableUuid, location, lastSequenceNumber, System.currentTimeMillis(), lastColumnId, schemas, currentSchemaId, partitionSpecs, 0, lastPartitionId, Collections.singletonList(new IcebergSortOrder()), 0, snapshots2, currentSnapshotId, new HashMap<String, String>(), refs);
    }

    @JsonCreator
    public IcebergMetadata(@JsonProperty(value="format-version") int formatVersion, @JsonProperty(value="table-uuid") String tableUuid, @JsonProperty(value="location") String location, @JsonProperty(value="last-sequence-number") long lastSequenceNumber, @JsonProperty(value="last-updated-ms") long lastUpdatedMs, @JsonProperty(value="last-column-id") int lastColumnId, @JsonProperty(value="schemas") List<IcebergSchema> schemas, @JsonProperty(value="current-schema-id") int currentSchemaId, @JsonProperty(value="partition-specs") List<IcebergPartitionSpec> partitionSpecs, @JsonProperty(value="default-spec-id") int defaultSpecId, @JsonProperty(value="last-partition-id") int lastPartitionId, @JsonProperty(value="sort-orders") List<IcebergSortOrder> sortOrders, @JsonProperty(value="default-sort-order-id") int defaultSortOrderId, @JsonProperty(value="snapshots") List<IcebergSnapshot> snapshots2, @JsonProperty(value="current-snapshot-id") long currentSnapshotId, @JsonProperty(value="properties") @Nullable Map<String, String> properties, @JsonProperty(value="refs") @Nullable Map<String, IcebergRef> refs) {
        this.formatVersion = formatVersion;
        this.tableUuid = tableUuid;
        this.location = location;
        this.lastSequenceNumber = lastSequenceNumber;
        this.lastUpdatedMs = lastUpdatedMs;
        this.lastColumnId = lastColumnId;
        this.schemas = schemas;
        this.currentSchemaId = currentSchemaId;
        this.partitionSpecs = partitionSpecs;
        this.defaultSpecId = defaultSpecId;
        this.lastPartitionId = lastPartitionId;
        this.sortOrders = sortOrders;
        this.defaultSortOrderId = defaultSortOrderId;
        this.snapshots = snapshots2;
        this.currentSnapshotId = currentSnapshotId;
        this.properties = properties;
        this.refs = refs;
    }

    @JsonGetter(value="format-version")
    public int formatVersion() {
        return this.formatVersion;
    }

    @JsonGetter(value="table-uuid")
    public String tableUuid() {
        return this.tableUuid;
    }

    @JsonGetter(value="location")
    public String location() {
        return this.location;
    }

    @JsonGetter(value="last-sequence-number")
    public long lastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    @JsonGetter(value="last-updated-ms")
    public long lastUpdatedMs() {
        return this.lastUpdatedMs;
    }

    @JsonGetter(value="last-column-id")
    public int lastColumnId() {
        return this.lastColumnId;
    }

    @JsonGetter(value="schemas")
    public List<IcebergSchema> schemas() {
        return this.schemas;
    }

    @JsonGetter(value="current-schema-id")
    public int currentSchemaId() {
        return this.currentSchemaId;
    }

    @JsonGetter(value="partition-specs")
    public List<IcebergPartitionSpec> partitionSpecs() {
        return this.partitionSpecs;
    }

    @JsonGetter(value="default-spec-id")
    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    @JsonGetter(value="last-partition-id")
    public int lastPartitionId() {
        return this.lastPartitionId;
    }

    @JsonGetter(value="sort-orders")
    public List<IcebergSortOrder> sortOrders() {
        return this.sortOrders;
    }

    @JsonGetter(value="default-sort-order-id")
    public int defaultSortOrderId() {
        return this.defaultSortOrderId;
    }

    @JsonGetter(value="snapshots")
    public List<IcebergSnapshot> snapshots() {
        return this.snapshots;
    }

    @JsonGetter(value="current-snapshot-id")
    public long currentSnapshotId() {
        return this.currentSnapshotId;
    }

    @JsonGetter(value="properties")
    public Map<String, String> properties() {
        return this.properties == null ? new HashMap() : this.properties;
    }

    @JsonGetter(value="refs")
    public Map<String, IcebergRef> refs() {
        return this.refs == null ? new HashMap() : this.refs;
    }

    public IcebergSnapshot currentSnapshot() {
        for (IcebergSnapshot snapshot : this.snapshots) {
            if (snapshot.snapshotId() != this.currentSnapshotId) continue;
            return snapshot;
        }
        throw new RuntimeException("Cannot find snapshot with id " + this.currentSnapshotId + ", this is unexpected.");
    }

    public String toJson() {
        return JsonSerdeUtil.toJson(this);
    }

    public static IcebergMetadata fromJson(String json) {
        return JsonSerdeUtil.fromJson(json, IcebergMetadata.class);
    }

    public static IcebergMetadata fromPath(FileIO fileIO, Path path) {
        try {
            String json = fileIO.readFileUtf8(path);
            return IcebergMetadata.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read Iceberg metadata from path " + path, e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.formatVersion, this.tableUuid, this.location, this.lastSequenceNumber, this.lastUpdatedMs, this.lastColumnId, this.schemas, this.currentSchemaId, this.partitionSpecs, this.defaultSpecId, this.lastPartitionId, this.sortOrders, this.defaultSortOrderId, this.snapshots, this.currentSnapshotId, this.refs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergMetadata)) {
            return false;
        }
        IcebergMetadata that = (IcebergMetadata)o;
        return this.formatVersion == that.formatVersion && Objects.equals(this.tableUuid, that.tableUuid) && Objects.equals(this.location, that.location) && this.lastSequenceNumber == that.lastSequenceNumber && this.lastUpdatedMs == that.lastUpdatedMs && this.lastColumnId == that.lastColumnId && Objects.equals(this.schemas, that.schemas) && this.currentSchemaId == that.currentSchemaId && Objects.equals(this.partitionSpecs, that.partitionSpecs) && this.defaultSpecId == that.defaultSpecId && this.lastPartitionId == that.lastPartitionId && Objects.equals(this.sortOrders, that.sortOrders) && this.defaultSortOrderId == that.defaultSortOrderId && Objects.equals(this.snapshots, that.snapshots) && this.currentSnapshotId == that.currentSnapshotId && Objects.equals(this.refs, that.refs);
    }
}

