/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.paimon.utils.CloseableIterator;

public interface FileWriter<T, R>
extends Closeable {
    public void write(T var1) throws IOException;

    default public void write(Iterator<T> records) throws Exception {
        while (records.hasNext()) {
            this.write(records.next());
        }
    }

    default public void write(CloseableIterator<T> records) throws Exception {
        try {
            while (records.hasNext()) {
                this.write(records.next());
            }
        }
        finally {
            records.close();
        }
    }

    default public void write(Iterable<T> records) throws IOException {
        for (T record : records) {
            this.write(record);
        }
    }

    public long recordCount();

    public void abort();

    public R result() throws IOException;
}

