/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.rocksdb;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.lookup.ByteArray;
import org.apache.paimon.lookup.ValueState;
import org.apache.paimon.lookup.rocksdb.RocksDBState;
import org.apache.paimon.lookup.rocksdb.RocksDBStateFactory;
import org.apache.paimon.utils.Preconditions;
import org.rocksdb.ColumnFamilyHandle;

public class RocksDBValueState<K, V>
extends RocksDBState<K, V, RocksDBState.Reference>
implements ValueState<K, V> {
    public RocksDBValueState(RocksDBStateFactory stateFactory, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(stateFactory, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Override
    @Nullable
    public V get(K key) throws IOException {
        try {
            RocksDBState.Reference valueRef = this.get(this.wrap(this.serializeKey(key)));
            return valueRef.isPresent() ? (V)this.deserializeValue(valueRef.bytes) : null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    private RocksDBState.Reference get(ByteArray keyBytes) throws Exception {
        RocksDBState.Reference valueRef = (RocksDBState.Reference)this.cache.getIfPresent(keyBytes);
        if (valueRef == null) {
            valueRef = this.ref(this.db.get(this.columnFamily, keyBytes.bytes));
            this.cache.put(keyBytes, valueRef);
        }
        return valueRef;
    }

    @Override
    public void put(K key, V value) throws IOException {
        Preconditions.checkArgument(value != null);
        try {
            byte[] keyBytes = this.serializeKey(key);
            byte[] valueBytes = this.serializeValue(value);
            this.db.put(this.columnFamily, this.writeOptions, keyBytes, valueBytes);
            this.cache.put(this.wrap(keyBytes), this.ref(valueBytes));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(K key) throws IOException {
        try {
            byte[] keyBytes = this.serializeKey(key);
            ByteArray keyByteArray = this.wrap(keyBytes);
            if (this.get(keyByteArray).isPresent()) {
                this.db.delete(this.columnFamily, this.writeOptions, keyBytes);
                this.cache.put(keyByteArray, this.ref(null));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

