/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;

public class BlockCache
implements Closeable {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final CacheManager cacheManager;
    private final Map<CacheKey, CacheManager.SegmentContainer> blocks;

    public BlockCache(RandomAccessFile file, CacheManager cacheManager) {
        this.file = file;
        this.channel = this.file.getChannel();
        this.cacheManager = cacheManager;
        this.blocks = new HashMap<CacheKey, CacheManager.SegmentContainer>();
    }

    private byte[] readFrom(long offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        int read = this.channel.read(ByteBuffer.wrap(buffer), offset);
        if (read != length) {
            throw new IOException("Could not read all the data");
        }
        return buffer;
    }

    public MemorySegment getBlock(long position, int length, Function<byte[], byte[]> decompressFunc, boolean isIndex) {
        CacheManager.SegmentContainer container;
        block3: {
            CacheKey cacheKey;
            block2: {
                cacheKey = CacheKey.forPosition(this.file, position, length, isIndex);
                container = this.blocks.get(cacheKey);
                if (container == null) break block2;
                if (container.getAccessCount() != 10) break block3;
            }
            MemorySegment segment = this.cacheManager.getPage(cacheKey, key -> {
                byte[] bytes = this.readFrom(position, length);
                return (byte[])decompressFunc.apply(bytes);
            }, this.blocks::remove);
            container = new CacheManager.SegmentContainer(segment);
            this.blocks.put(cacheKey, container);
        }
        return container.access();
    }

    @Override
    public void close() throws IOException {
        HashSet<CacheKey> sets = new HashSet<CacheKey>(this.blocks.keySet());
        for (CacheKey key : sets) {
            this.cacheManager.invalidPage(key);
        }
    }
}

