/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.compression.CompressOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.WriteBuffer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.sort.BinaryExternalSortBuffer;
import org.apache.paimon.sort.BinaryInMemorySortBuffer;
import org.apache.paimon.sort.SortBuffer;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.MutableObjectIterator;

public class SortBufferWriteBuffer
implements WriteBuffer {
    private final RowType keyType;
    private final RowType valueType;
    private final KeyValueSerializer serializer;
    private final SortBuffer buffer;

    public SortBufferWriteBuffer(RowType keyType, RowType valueType, @Nullable FieldsComparator userDefinedSeqComparator, MemorySegmentPool memoryPool, boolean spillable, MemorySize maxDiskSize, int sortMaxFan, CompressOptions compression, IOManager ioManager) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.serializer = new KeyValueSerializer(keyType, valueType);
        IntStream sortFields = IntStream.range(0, keyType.getFieldCount());
        if (userDefinedSeqComparator != null) {
            IntStream udsFields = IntStream.of(userDefinedSeqComparator.compareFields()).map(operand -> operand + keyType.getFieldCount() + 2);
            sortFields = IntStream.concat(sortFields, udsFields);
        }
        sortFields = IntStream.concat(sortFields, IntStream.of(keyType.getFieldCount()));
        int[] sortFieldArray = sortFields.toArray();
        ArrayList<DataType> fieldTypes = new ArrayList<DataType>(keyType.getFieldTypes());
        fieldTypes.add(new BigIntType(false));
        fieldTypes.add(new TinyIntType(false));
        fieldTypes.addAll(valueType.getFieldTypes());
        NormalizedKeyComputer normalizedKeyComputer = CodeGenUtils.newNormalizedKeyComputer(fieldTypes, sortFieldArray);
        RecordComparator keyComparator = CodeGenUtils.newRecordComparator(fieldTypes, sortFieldArray, true);
        if (memoryPool.freePages() < 3) {
            throw new IllegalArgumentException("Write buffer requires a minimum of 3 page memory, please increase write buffer memory size.");
        }
        InternalRowSerializer serializer = InternalSerializers.create(KeyValue.schema(keyType, valueType));
        BinaryInMemorySortBuffer inMemorySortBuffer = BinaryInMemorySortBuffer.createBuffer(normalizedKeyComputer, serializer, keyComparator, memoryPool);
        this.buffer = ioManager != null && spillable ? new BinaryExternalSortBuffer(new BinaryRowSerializer(serializer.getArity()), keyComparator, memoryPool.pageSize(), inMemorySortBuffer, ioManager, sortMaxFan, compression, maxDiskSize) : inMemorySortBuffer;
    }

    @Override
    public boolean put(long sequenceNumber, RowKind valueKind, InternalRow key, InternalRow value) throws IOException {
        return this.buffer.write(this.serializer.toRow(key, sequenceNumber, valueKind, value));
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public long memoryOccupancy() {
        return this.buffer.getOccupancy();
    }

    @Override
    public boolean flushMemory() throws IOException {
        return this.buffer.flushMemory();
    }

    @Override
    public void forEach(Comparator<InternalRow> keyComparator, MergeFunction<KeyValue> mergeFunction, @Nullable WriteBuffer.KvConsumer rawConsumer, WriteBuffer.KvConsumer mergedConsumer) throws IOException {
        MergeIterator mergeIterator = new MergeIterator(rawConsumer, this.buffer.sortedIterator(), keyComparator, mergeFunction);
        while (mergeIterator.hasNext()) {
            mergedConsumer.accept(mergeIterator.next());
        }
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @VisibleForTesting
    SortBuffer buffer() {
        return this.buffer;
    }

    private class MergeIterator {
        @Nullable
        private final WriteBuffer.KvConsumer rawConsumer;
        private final MutableObjectIterator<BinaryRow> kvIter;
        private final Comparator<InternalRow> keyComparator;
        private final ReducerMergeFunctionWrapper mergeFunctionWrapper;
        private final boolean requireCopy;
        private KeyValueSerializer previous;
        private BinaryRow previousRow;
        private KeyValueSerializer current;
        private BinaryRow currentRow;
        private KeyValue result;
        private boolean advanced;

        private MergeIterator(WriteBuffer.KvConsumer rawConsumer, MutableObjectIterator<BinaryRow> kvIter, Comparator<InternalRow> keyComparator, MergeFunction<KeyValue> mergeFunction) throws IOException {
            this.rawConsumer = rawConsumer;
            this.kvIter = kvIter;
            this.keyComparator = keyComparator;
            this.mergeFunctionWrapper = new ReducerMergeFunctionWrapper(mergeFunction);
            this.requireCopy = mergeFunction.requireCopy();
            int totalFieldCount = SortBufferWriteBuffer.this.keyType.getFieldCount() + 2 + SortBufferWriteBuffer.this.valueType.getFieldCount();
            this.previous = new KeyValueSerializer(SortBufferWriteBuffer.this.keyType, SortBufferWriteBuffer.this.valueType);
            this.previousRow = new BinaryRow(totalFieldCount);
            this.current = new KeyValueSerializer(SortBufferWriteBuffer.this.keyType, SortBufferWriteBuffer.this.valueType);
            this.currentRow = new BinaryRow(totalFieldCount);
            this.readOnce();
            this.advanced = false;
        }

        public boolean hasNext() throws IOException {
            this.advanceIfNeeded();
            return this.previousRow != null;
        }

        public KeyValue next() throws IOException {
            this.advanceIfNeeded();
            if (this.previousRow == null) {
                return null;
            }
            this.advanced = false;
            return this.result;
        }

        private void advanceIfNeeded() throws IOException {
            if (this.advanced) {
                return;
            }
            this.advanced = true;
            do {
                this.swapSerializers();
                if (this.previousRow == null) {
                    return;
                }
                this.mergeFunctionWrapper.reset();
                this.mergeFunctionWrapper.add(this.requireCopy ? this.previous.getCopiedKv() : this.previous.getReusedKv());
                while (this.readOnce() && this.keyComparator.compare(this.previous.getReusedKv().key(), this.current.getReusedKv().key()) == 0) {
                    this.mergeFunctionWrapper.add(this.requireCopy ? this.current.getCopiedKv() : this.current.getReusedKv());
                    this.swapSerializers();
                }
                this.result = this.mergeFunctionWrapper.getResult();
            } while (this.result == null);
        }

        private boolean readOnce() throws IOException {
            try {
                this.currentRow = this.kvIter.next(this.currentRow);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.currentRow != null) {
                this.current.fromRow(this.currentRow);
                if (this.rawConsumer != null) {
                    this.rawConsumer.accept(this.current.getReusedKv());
                }
            }
            return this.currentRow != null;
        }

        private void swapSerializers() {
            KeyValueSerializer tmp = this.previous;
            BinaryRow tmpRow = this.previousRow;
            this.previous = this.current;
            this.previousRow = this.currentRow;
            this.current = tmp;
            this.currentRow = tmpRow;
        }
    }
}

