/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Preconditions;

public class FirstRowMergeFunctionWrapper
implements MergeFunctionWrapper<ChangelogResult> {
    private final Filter<InternalRow> contains;
    private final FirstRowMergeFunction mergeFunction;
    private final ChangelogResult reusedResult = new ChangelogResult();

    public FirstRowMergeFunctionWrapper(MergeFunctionFactory<KeyValue> mergeFunctionFactory, Filter<InternalRow> contains) {
        this.contains = contains;
        MergeFunction<KeyValue> mergeFunction = mergeFunctionFactory.create();
        Preconditions.checkArgument(mergeFunction instanceof FirstRowMergeFunction, "Merge function should be a FirstRowMergeFunction, but is %s, there is a bug.", mergeFunction.getClass().getName());
        this.mergeFunction = (FirstRowMergeFunction)mergeFunction;
    }

    @Override
    public void reset() {
        this.mergeFunction.reset();
    }

    @Override
    public void add(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public ChangelogResult getResult() {
        this.reusedResult.reset();
        KeyValue result = this.mergeFunction.getResult();
        if (this.mergeFunction.containsHighLevel) {
            this.reusedResult.setResult(result);
            return this.reusedResult;
        }
        if (this.contains.test(result.key())) {
            return this.reusedResult;
        }
        return this.reusedResult.setResult(result).addChangelog(result);
    }
}

