/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.filter2.recordlevel;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.Operators;
import org.apache.paimon.shade.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.paimon.shade.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.paimon.shade.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilderBase;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.paimon.shade.org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveComparator;

public class IncrementallyUpdatedFilterPredicateBuilder
extends IncrementallyUpdatedFilterPredicateBuilderBase {
    public IncrementallyUpdatedFilterPredicateBuilder(List<PrimitiveColumnIO> leaves) {
        super(leaves);
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Eq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(false);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(comparator22.compare(value, n) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(false);
                    }
                };
            } else {
                final long l = (Long)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(comparator2.compare(value, l) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(false);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(comparator.compare(value, bl) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(false);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(comparator.compare(value, f) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(false);
                    }
                };
            } else {
                final double d = (Double)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(comparator2.compare(value, d) == 0);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(false);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(comparator.compare(value, binary) == 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(true);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(comparator22.compare(value, n) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(true);
                    }
                };
            } else {
                final long l = (Long)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(comparator2.compare(value, l) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(true);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(comparator.compare(value, bl) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(true);
                    }
                };
            } else {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(comparator.compare(value, f) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(true);
                    }
                };
            } else {
                final double d = (Double)pred.getValue();
                comparator2 = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(comparator2.compare(value, d) != 0);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(true);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(comparator.compare(value, binary) != 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.In<T> pred) {
        PrimitiveComparator comparator;
        Set target;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            int i = (Integer)iterator2.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            long i = (Long)iterator2.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            boolean i = (Boolean)iterator2.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            float i = ((Float)iterator2.next()).floatValue();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            double i = (Double)iterator2.next();
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(false);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        for (Binary i : target) {
                            if (comparator.compare(value, i) != 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotIn<T> pred) {
        PrimitiveComparator comparator;
        Set target;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            int i = (Integer)iterator2.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Long.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            long i = (Long)iterator2.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Boolean.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            boolean i = (Boolean)iterator2.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Float.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            float i = ((Float)iterator2.next()).floatValue();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Double.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        Iterator iterator2 = target.iterator();
                        while (iterator2.hasNext()) {
                            double i = (Double)iterator2.next();
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (clazz.equals(Binary.class)) {
            if (pred.getValues().contains(null)) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        this.setResult(true);
                    }
                };
            } else {
                target = pred.getValues();
                comparator = this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        for (Binary i : target) {
                            if (comparator.compare(value, i) == 0) continue;
                            this.setResult(true);
                            return;
                        }
                        this.setResult(false);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Contains<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        Object valueInspector = null;
        valueInspector = new ContainsInspectorVisitor().visit((Operators.Contains)pred);
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, (IncrementallyUpdatedFilterPredicate.ValueInspector)valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Lt<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator < not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) < 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) < 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LtEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator <= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) <= 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) <= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Gt<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator > not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) > 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) > 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.GtEq<T> pred) {
        PrimitiveComparator comparator;
        PrimitiveComparator comparator2;
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value) {
                    this.setResult(comparator.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator >= not supported for Boolean");
        }
        if (clazz.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            comparator = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value) {
                    this.setResult(comparator.compare(value, target) >= 0);
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            comparator2 = this.getComparator(columnPath);
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value) {
                    this.setResult(comparator2.compare(value, target) >= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.UserDefined<T, U> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(int value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(long value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(boolean value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(float value) {
                    this.setResult(this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(double value) {
                    this.setResult(this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(Binary value) {
                    this.setResult(this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LogicalNotUserDefined<T, U> notPred) {
        Operators.UserDefined<T, U> pred = notPred.getUserDefined();
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(int value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(long value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(boolean value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(float value) {
                    this.setResult(!this.val$udp.keep((Comparable)Float.valueOf(value)));
                }
            };
        }
        if (clazz.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(double value) {
                    this.setResult(!this.val$udp.keep(value));
                }
            };
        }
        if (clazz.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.acceptsNullValue());
                }

                @Override
                public void update(Binary value) {
                    this.setResult(!this.val$udp.keep((Comparable)value));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    private class ContainsInspectorVisitor
    implements FilterPredicate.Visitor<ContainsPredicate> {
        private ContainsInspectorVisitor() {
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.Contains<T> contains) {
            return contains.filter(this, (x$0, x$1) -> new ContainsAndPredicate((ContainsPredicate)x$0, (ContainsPredicate)x$1), (x$0, x$1) -> new ContainsOrPredicate((ContainsPredicate)x$0, (ContainsPredicate)x$1), ContainsPredicate::not);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.Eq<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator22.compare(value, n) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long l = (Long)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator2.compare(value, l) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                final boolean bl = (Boolean)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value) {
                        if (!this.isKnown() && comparator.compare(value, bl) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Float.class)) {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator.compare(value, f) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double d = (Double)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator2.compare(value, d) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary binary = (Binary)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator.compare(value, binary) == 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.NotEq<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int n = (Integer)pred.getValue();
                final PrimitiveComparator comparator22 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator22.compare(value, n) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long l = (Long)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator2.compare(value, l) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                final boolean bl = (Boolean)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value) {
                        if (!this.isKnown() && comparator.compare(value, bl) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Float.class)) {
                final float f = ((Float)pred.getValue()).floatValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator.compare(value, f) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double d = (Double)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator2.compare(value, d) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary binary = (Binary)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator.compare(value, binary) != 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.Lt<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int target = (Integer)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator2.compare(value, target) < 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long target = (Long)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator.compare(value, target) < 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                throw new IllegalArgumentException("Operator < not supported for Boolean");
            }
            if (clazz.equals(Float.class)) {
                final float target = ((Float)pred.getValue()).floatValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator2.compare(value, target) < 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double target = (Double)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator.compare(value, target) < 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary target = (Binary)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator2.compare(value, target) < 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.LtEq<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int target = (Integer)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator2.compare(value, target) <= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long target = (Long)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator.compare(value, target) <= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                throw new IllegalArgumentException("Operator <= not supported for Boolean");
            }
            if (clazz.equals(Float.class)) {
                final float target = ((Float)pred.getValue()).floatValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator2.compare(value, target) <= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double target = (Double)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator.compare(value, target) <= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary target = (Binary)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator2.compare(value, target) <= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.Gt<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int target = (Integer)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator2.compare(value, target) > 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long target = (Long)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator.compare(value, target) > 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                throw new IllegalArgumentException("Operator > not supported for Boolean");
            }
            if (clazz.equals(Float.class)) {
                final float target = ((Float)pred.getValue()).floatValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator2.compare(value, target) > 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double target = (Double)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator.compare(value, target) > 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary target = (Binary)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator2.compare(value, target) > 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.GtEq<T> pred) {
            PrimitiveComparator comparator;
            PrimitiveComparator comparator2;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                final int target = (Integer)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value) {
                        if (!this.isKnown() && comparator2.compare(value, target) >= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Long.class)) {
                final long target = (Long)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value) {
                        if (!this.isKnown() && comparator.compare(value, target) >= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Boolean.class)) {
                throw new IllegalArgumentException("Operator >= not supported for Boolean");
            }
            if (clazz.equals(Float.class)) {
                final float target = ((Float)pred.getValue()).floatValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value) {
                        if (!this.isKnown() && comparator2.compare(value, target) >= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Double.class)) {
                final double target = (Double)pred.getValue();
                comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value) {
                        if (!this.isKnown() && comparator.compare(value, target) >= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            if (clazz.equals(Binary.class)) {
                final Binary target = (Binary)pred.getValue();
                comparator2 = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value) {
                        if (!this.isKnown() && comparator2.compare(value, target) >= 0) {
                            this.setResult(true);
                        }
                    }
                };
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.In<T> pred) {
            PrimitiveComparator comparator;
            Set target;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(int value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(int value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                int i = (Integer)iterator2.next();
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Long.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(long value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(long value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                long i = (Long)iterator2.next();
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Boolean.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(boolean value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(boolean value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                boolean i = (Boolean)iterator2.next();
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Float.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(float value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(float value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                float i = ((Float)iterator2.next()).floatValue();
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Double.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(double value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(double value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                double i = (Double)iterator2.next();
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Binary.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(Binary value) {
                            this.setResult(false);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(Binary value) {
                            if (this.isKnown()) {
                                return;
                            }
                            for (Binary i : target) {
                                if (comparator.compare(value, i) != 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public <T extends Comparable<T>> ContainsPredicate visit(Operators.NotIn<T> pred) {
            PrimitiveComparator comparator;
            Set target;
            ColumnPath columnPath = pred.getColumn().getColumnPath();
            Class clazz = pred.getColumn().getColumnType();
            IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
            if (clazz.equals(Integer.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(int value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(int value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                int i = (Integer)iterator2.next();
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Long.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(long value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(long value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                long i = (Long)iterator2.next();
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Boolean.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(boolean value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(boolean value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                boolean i = (Boolean)iterator2.next();
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Float.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(float value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(float value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                float i = ((Float)iterator2.next()).floatValue();
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Double.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(double value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(double value) {
                            if (this.isKnown()) {
                                return;
                            }
                            Iterator iterator2 = target.iterator();
                            while (iterator2.hasNext()) {
                                double i = (Double)iterator2.next();
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            if (clazz.equals(Binary.class)) {
                if (pred.getValues().contains(null)) {
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(false);
                        }

                        @Override
                        public void update(Binary value) {
                            this.setResult(true);
                        }
                    };
                } else {
                    target = pred.getValues();
                    comparator = IncrementallyUpdatedFilterPredicateBuilder.this.getComparator(columnPath);
                    valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                        @Override
                        public void updateNull() {
                            this.setResult(true);
                        }

                        @Override
                        public void update(Binary value) {
                            if (this.isKnown()) {
                                return;
                            }
                            for (Binary i : target) {
                                if (comparator.compare(value, i) == 0) continue;
                                this.setResult(true);
                                return;
                            }
                        }
                    };
                }
            }
            return new ContainsSinglePredicate(valueInspector, false);
        }

        @Override
        public ContainsPredicate visit(Operators.And pred) {
            throw new UnsupportedOperationException("Operators.And not supported for Contains predicate");
        }

        @Override
        public ContainsPredicate visit(Operators.Or pred) {
            throw new UnsupportedOperationException("Operators.Or not supported for Contains predicate");
        }

        @Override
        public ContainsPredicate visit(Operators.Not pred) {
            throw new UnsupportedOperationException("Operators.Not not supported for Contains predicate");
        }

        @Override
        public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> ContainsPredicate visit(Operators.UserDefined<T, U> pred) {
            throw new UnsupportedOperationException("UserDefinedPredicate not supported for Contains predicate");
        }

        @Override
        public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> ContainsPredicate visit(Operators.LogicalNotUserDefined<T, U> pred) {
            throw new UnsupportedOperationException("LogicalNotUserDefined not supported for Contains predicate");
        }
    }

    private static class ContainsOrPredicate
    extends ContainsPredicate {
        private ContainsOrPredicate(ContainsPredicate left, ContainsPredicate right) {
            super(left, right);
        }

        @Override
        void onUpdate() {
            if (this.isKnown()) {
                return;
            }
            for (IncrementallyUpdatedFilterPredicate.ValueInspector delegate : this.getDelegates()) {
                if (!delegate.isKnown() || !delegate.getResult()) continue;
                this.setResult(true);
            }
        }

        @Override
        void onNull() {
            for (IncrementallyUpdatedFilterPredicate.ValueInspector delegate : this.getDelegates()) {
                if (!delegate.getResult()) continue;
                this.setResult(true);
                return;
            }
            this.setResult(false);
        }

        @Override
        ContainsPredicate not() {
            Iterator<IncrementallyUpdatedFilterPredicate.ValueInspector> it = this.getDelegates().iterator();
            return new ContainsOrPredicate(((ContainsPredicate)it.next()).not(), ((ContainsPredicate)it.next()).not());
        }
    }

    private static class ContainsAndPredicate
    extends ContainsPredicate {
        private ContainsAndPredicate(ContainsPredicate left, ContainsPredicate right) {
            super(left, right);
        }

        @Override
        void onUpdate() {
            if (this.isKnown()) {
                return;
            }
            boolean allKnown = true;
            for (IncrementallyUpdatedFilterPredicate.ValueInspector delegate : this.getDelegates()) {
                if (delegate.isKnown() && !delegate.getResult()) {
                    this.setResult(false);
                    return;
                }
                allKnown = allKnown && delegate.isKnown();
            }
            if (allKnown) {
                this.setResult(true);
            }
        }

        @Override
        void onNull() {
            for (IncrementallyUpdatedFilterPredicate.ValueInspector delegate : this.getDelegates()) {
                if (delegate.getResult()) continue;
                this.setResult(false);
                return;
            }
            this.setResult(true);
        }

        @Override
        ContainsPredicate not() {
            Iterator<IncrementallyUpdatedFilterPredicate.ValueInspector> it = this.getDelegates().iterator();
            return new ContainsAndPredicate(((ContainsPredicate)it.next()).not(), ((ContainsPredicate)it.next()).not());
        }
    }

    private static class ContainsSinglePredicate
    extends ContainsPredicate {
        private final boolean isNot;

        private ContainsSinglePredicate(IncrementallyUpdatedFilterPredicate.ValueInspector inspector, boolean isNot) {
            super(inspector);
            this.isNot = isNot;
        }

        @Override
        ContainsPredicate not() {
            return new ContainsSinglePredicate(this.getDelegates().iterator().next(), true);
        }

        @Override
        void onUpdate() {
            if (this.isKnown()) {
                return;
            }
            for (IncrementallyUpdatedFilterPredicate.ValueInspector inspector : this.getDelegates()) {
                if (!inspector.isKnown() || !inspector.getResult()) continue;
                this.setResult(!this.isNot);
                return;
            }
        }

        @Override
        void onNull() {
            this.setResult(this.isNot);
        }
    }

    private static abstract class ContainsPredicate
    extends IncrementallyUpdatedFilterPredicate.DelegatingValueInspector {
        ContainsPredicate(IncrementallyUpdatedFilterPredicate.ValueInspector ... delegates) {
            super(delegates);
        }

        abstract ContainsPredicate not();
    }
}

