/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.PartitionKeyExtractor;

public class RowPartitionAllPrimaryKeyExtractor
implements PartitionKeyExtractor<InternalRow> {
    private final Projection partitionProjection;
    private final Projection primaryKeyProjection;

    public RowPartitionAllPrimaryKeyExtractor(TableSchema schema) {
        this.partitionProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.partitionKeys()));
        this.primaryKeyProjection = CodeGenUtils.newProjection(schema.logicalRowType(), schema.projection(schema.primaryKeys()));
    }

    @Override
    public BinaryRow partition(InternalRow record) {
        return this.partitionProjection.apply(record);
    }

    @Override
    public BinaryRow trimmedPrimaryKey(InternalRow record) {
        return this.primaryKeyProjection.apply(record);
    }
}

